/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.administrationtools.autotask;

import com.suncode.plugin.administrationtools.Categories;
import com.suncode.plugin.administrationtools.service.UserManagementService;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.variablesetter.annotation.VariableSetter;
import com.suncode.pwfl.workflow.invocable.CommonDefinitionBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

@Application
@VariableSetter
@ComponentsFormScript(value="scripts/dynamic-form-pwe/create-organization-unit-form.js")
public class CreateOrganizationUnit {
    private static final Logger log = LoggerFactory.getLogger(CreateOrganizationUnit.class);
    @Autowired
    private UserManagementService userManagementService;

    @Define
    public void definition(CommonDefinitionBuilder builder) {
        ((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)builder.id("create-organization-unit")).name("application.create-organization-unit.name")).description("application.create-organization-unit.desc")).category(new Category[]{Categories.USER_MANAGEMENT})).icon((Icon)SilkIconPack.NEW)).parameter().id("name").name("application.create-organization-unit.param.name.name").type((Type)Types.STRING_ARRAY).create()).parameter().id("symbol").name("application.create-organization-unit.param.symbol.name").type((Type)Types.STRING_ARRAY).create()).parameter().id("overridingUnitSymbol").optional().name("application.create-organization-unit.param.overriding-unit-symbol.name").type((Type)Types.STRING_ARRAY).create()).parameter().id("managerialPositionSymbol").optional().name("application.create-organization-unit.param.managerial-position-symbol.name").type((Type)Types.STRING_ARRAY).create();
    }

    public void execute(@Param String[] name, @Param String[] symbol, @Param String[] overridingUnitSymbol, @Param String[] managerialPositionSymbol) {
        this.run(name, symbol, overridingUnitSymbol, managerialPositionSymbol);
    }

    public void set(@Param String[] name, @Param String[] symbol, @Param String[] overridingUnitSymbol, @Param String[] managerialPositionSymbol) {
        this.run(name, symbol, overridingUnitSymbol, managerialPositionSymbol);
    }

    private void run(String[] name, String[] symbol, String[] overridingUnitSymbol, String[] managerialPositionSymbol) {
        for (int organizationUnitNo = 0; organizationUnitNo < name.length; ++organizationUnitNo) {
            this.createOrganizationUnit(name[organizationUnitNo], symbol[organizationUnitNo], overridingUnitSymbol[organizationUnitNo], managerialPositionSymbol[organizationUnitNo]);
        }
    }

    private void createOrganizationUnit(String name, String symbol, String overridingUnitSymbol, String managerialPositionSymbol) {
        Assert.isTrue((!name.isEmpty() ? 1 : 0) != 0, (String)"Organization unit name is empty");
        Assert.isTrue((!symbol.isEmpty() ? 1 : 0) != 0, (String)"Organization unit symbol is empty");
        this.userManagementService.createOrganizationUnit(name, symbol, overridingUnitSymbol, managerialPositionSymbol);
        log.debug(String.join((CharSequence)"", "Organization unit has been created. Name: ", name, ", Symbol: ", symbol, ", overriding unit symbol: ", overridingUnitSymbol, ", managerialPositionSymbol: ", managerialPositionSymbol));
    }
}

