PWE.integrationComponent.registerSystemFunction('PCMConfig.getConfigIds', [{
    type: 'string',
    id: 'pluginId',
}], {
    apiVersion: 2,
    buildForm: function(form) {
        const responseData = [];
        jQuery.ajax({
            url: PW.getAbsolutePath('plugin/com.suncode.plugin-plugin-configuration-manager/configuration/all'),
            contentType: "application/json",
            async: false,
            method: 'GET',
            success: function (response) {
                for (let i = 0; i < response.size(); i++) {
                    responseData[i] = {id: response[i].pluginInfo.id, display: response[i].pluginInfo.name, description: response[i].pluginInfo.name};
                }
            },
            error: function() {
                Logger.error("Failed to retrieve the list of plugin IDs.");
            },
            complete: function() {
                form.addCombobox({
                    id: "pluginId",
                    values: responseData,
                    displayField: "display",
                    valueField: "id"
                });
            }
        });
    }
});