PWE.integrationComponent.registerApplication('add-calendar-resource-group-permission', {
    apiVersion: 2,
    buildForm: function (form) {
        buildForm(form);
    }
});

PWE.integrationComponent.registerVariablesSetter('add-calendar-resource-group-permission', {
    apiVersion: 2,
    buildForm: function (form) {
        buildForm(form);
    }
});

function buildForm(form) {
    form.addField({
        id: 'resourceGroupId'
    });

    form.addCombobox({
        id: 'permissionType',
        values: [
            {
                id: 'USER',
                display: PLUGIN_ADMINISTRATION_TOOLS.t('application.add-calendar-resource-group-permission.param.permission-type.value.user')
            },
            {
                id: 'GROUP',
                display: PLUGIN_ADMINISTRATION_TOOLS.t('application.add-calendar-resource-group-permission.param.permission-type.value.group')
            }
        ],
        listeners: {
            change: function (value) {
                updateFormFields(form, value);
            }
        }
    });

    form.addField('usernames');
    form.addField('groupNames');

    let outputFieldSet = form.addFieldSet({
        id: 'outputFields',
        title: PLUGIN_ADMINISTRATION_TOOLS.t("application.add-calendar-resource-group-permission.output-fieldset.title"),
        collapsible: false,
        collapsed: false
    });

    outputFieldSet.addField({
        id: 'targetVariable'
    });

    outputFieldSet.addField({
        id: 'value'
    });

    let defaultPermissionType = form.getValue('permissionType') || 'USER';
    updateFormFields(form, defaultPermissionType);
}

function updateFormFields(form, permissionType) {
    if (permissionType === 'USER') {
        form.show('usernames');
        form.resetArray("groupNames")
        form.hide('groupNames');
    } else {
        form.show('groupNames');
        form.resetArray("usernames")
        form.hide('usernames');
    }
}