/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.administrationtools.service;

import com.suncode.plugin.administrationtools.dto.PositionInfo;
import com.suncode.plugin.administrationtools.dto.RoleInfo;
import com.suncode.plugin.administrationtools.scheduledtask.enums.OperationMode;
import com.suncode.plugin.administrationtools.service.UserManagementService;
import com.suncode.plugin.administrationtools.support.IgnoreException;
import com.suncode.plugin.administrationtools.support.IgnoringGroupNotFoundException;
import com.suncode.plugin.administrationtools.support.SharkUtils;
import com.suncode.pwfl.administration.structure.OrganizationalUnit;
import com.suncode.pwfl.administration.structure.OrganizationalUnitFinder;
import com.suncode.pwfl.administration.structure.Position;
import com.suncode.pwfl.administration.structure.PositionFinder;
import com.suncode.pwfl.administration.structure.Role;
import com.suncode.pwfl.administration.structure.RoleService;
import com.suncode.pwfl.administration.structure.StructureService;
import com.suncode.pwfl.administration.user.Deactivation;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserFinder;
import com.suncode.pwfl.administration.user.UserGroup;
import com.suncode.pwfl.administration.user.UserGroupFinder;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.administration.user.exception.GroupNotFoundException;
import com.suncode.pwfl.administration.user.exception.UserAlreadyExistException;
import com.suncode.pwfl.administration.user.exception.UserNotFoundException;
import com.suncode.pwfl.translation.Translator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@Transactional
public class UserManagementServiceImpl
implements UserManagementService {
    private static final String ID = "plusadministrationtools.service.UserManagementService";
    @Autowired
    private UserService userService;
    @Autowired
    private UserFinder userFinder;
    @Autowired
    private StructureService structureService;
    @Autowired
    private PositionFinder positionFinder;
    @Autowired
    private OrganizationalUnitFinder organizationalUnitFinder;
    @Autowired
    private RoleService roleService;
    @Autowired
    private UserGroupFinder userGroupFinder;

    @Override
    public void removeUserFromGroups(String login, List<String> groups) {
        User user = this.findUserByLogin(login);
        List groupsToRemove = user.getGroups().stream().map(UserGroup::getName).filter(groups::contains).collect(Collectors.toList());
        if (!groupsToRemove.isEmpty()) {
            this.userService.removeUserFromGroups(login, groupsToRemove);
        }
    }

    @Override
    public boolean isUserExist(String login) {
        return this.userService.getUser(login, new String[0]) != null;
    }

    @Override
    public void addUserToGroups(String login, List<String> groupList) throws GroupNotFoundException {
        this.userService.addUserToGroups(login, groupList);
    }

    @Override
    public boolean createGroupIfNotExist(String name, String description) {
        if (this.isGroupExist(name)) {
            return false;
        }
        UserGroup userGroup = new UserGroup(name);
        userGroup.setDescription(description);
        IgnoreException.ignoringGroupAlreadyExistException(() -> this.userService.createGroup(userGroup));
        return true;
    }

    @Override
    public boolean isGroupExist(String name) {
        return this.userService.getGroup(name, new String[0]) != null;
    }

    @Override
    public void createOrganizationUnit(String name, String symbol, String overridingUnitSymbol, String managerialPositionSymbol) {
        OrganizationalUnit organizationalUnit = new OrganizationalUnit();
        organizationalUnit.setName(name);
        organizationalUnit.setSymbol(symbol);
        if (StringUtils.isNotBlank((CharSequence)overridingUnitSymbol)) {
            OrganizationalUnit overridingOrganizationalUnit = this.structureService.getOrganizationalUnit(overridingUnitSymbol, new String[0]);
            Assert.isTrue((overridingOrganizationalUnit != null ? 1 : 0) != 0, (String)"Incorrect overriding position symbol");
            organizationalUnit.setHigherOrganizationalUnit(overridingOrganizationalUnit);
        }
        if (StringUtils.isNotBlank((CharSequence)managerialPositionSymbol)) {
            Position managerialPosition = this.positionFinder.findBySymbol(managerialPositionSymbol, new String[0]);
            Assert.isTrue((managerialPosition != null ? 1 : 0) != 0, (String)"Incorrect managerial position symbol");
            organizationalUnit.setDirectorPosition(this.positionFinder.findBySymbol(managerialPositionSymbol, new String[0]));
        }
        this.structureService.createOrganizationalUnit(organizationalUnit);
    }

    @Override
    public void createPosition(PositionInfo positionInfo, Translator translator) {
        Position position = new Position(positionInfo.getName(), positionInfo.getSymbol());
        Assert.isTrue((this.positionFinder.findBySymbol(positionInfo.getSymbol(), new String[0]) == null ? 1 : 0) != 0, (String)translator.getMessage(ID.concat(".configuration.OrganizationUnitSymbolAlreadyExists")));
        if (StringUtils.isNotBlank((CharSequence)positionInfo.getOverridingPositionSymbol())) {
            this.setPositionHigherPosition(position, positionInfo.getOverridingPositionSymbol(), translator);
        }
        if (StringUtils.isNotBlank((CharSequence)positionInfo.getUnitSymbol())) {
            this.setPositionOrganizationalUnit(position, positionInfo.getUnitSymbol(), translator);
        }
        if (!positionInfo.getRoleInfos().isEmpty()) {
            this.setPositionRoles(position, positionInfo.getRoleInfos(), translator);
        }
        this.structureService.createPosition(position);
    }

    @Override
    public void updatePosition(String overridingPositionSymbolSavingSettings, String unitSymbolSavingSettings, String roleSymbolsSavingSettings, PositionInfo positionInfo, Translator translator) {
        Position position = this.positionFinder.findBySymbol(positionInfo.getSymbol(), new String[]{"roles"});
        Assert.isTrue((position != null ? 1 : 0) != 0, (String)translator.getMessage(ID.concat(".configuration.GivenPositionDoesNotExist")));
        if (overridingPositionSymbolSavingSettings.equals("OVERWRITE")) {
            if (StringUtils.isEmpty((CharSequence)positionInfo.getOverridingPositionSymbol())) {
                position.setHigherPosition(null);
            } else {
                this.setPositionHigherPosition(position, positionInfo.getOverridingPositionSymbol(), translator);
            }
        }
        if (overridingPositionSymbolSavingSettings.equals("OVERWRITE")) {
            if (StringUtils.isEmpty((CharSequence)positionInfo.getUnitSymbol())) {
                position.setOrganizationalUnit(null);
            }
            this.setPositionOrganizationalUnit(position, positionInfo.getUnitSymbol(), translator);
        }
        switch (roleSymbolsSavingSettings) {
            case "OVERWRITE": {
                if (positionInfo.getRoleInfos().isEmpty()) {
                    position.setRoles(Collections.emptySet());
                    break;
                }
                this.setPositionRoles(position, positionInfo.getRoleInfos(), translator);
                break;
            }
            case "APPEND": {
                Set totalRoles = position.getRoles();
                totalRoles.addAll(this.getPositionRoles(positionInfo.getRoleInfos(), translator));
                position.setRoles(totalRoles);
                break;
            }
        }
        this.structureService.updatePosition(position);
    }

    private void setPositionHigherPosition(Position position, String overridingPositionSymbol, Translator translator) {
        Position overridingPosition = this.positionFinder.findBySymbol(overridingPositionSymbol, new String[0]);
        Assert.isTrue((overridingPosition != null ? 1 : 0) != 0, (String)translator.getMessage(ID.concat(".configuration.incorrectOverridingPositionSymbol")));
        position.setHigherPosition(overridingPosition);
    }

    private void setPositionOrganizationalUnit(Position position, String unitSymbol, Translator translator) {
        OrganizationalUnit organizationalUnit = this.organizationalUnitFinder.findBySymbol(unitSymbol, new String[0]);
        Assert.isTrue((organizationalUnit != null ? 1 : 0) != 0, (String)translator.getMessage(ID.concat(".configuration.incorrectOrganizationUnitSymbol")));
        position.setOrganizationalUnit(organizationalUnit);
    }

    private void setPositionRoles(Position position, List<RoleInfo> roleInfos, Translator translator) {
        position.setRoles(this.getPositionRoles(roleInfos, translator));
    }

    private Set<Role> getPositionRoles(List<RoleInfo> roleInfos, Translator translator) {
        return roleInfos.stream().map(roleInfo -> {
            Role role = this.roleService.getRole(roleInfo.getPackageId(), roleInfo.getProcessDefId(), roleInfo.getRoleId());
            Assert.isTrue((role != null ? 1 : 0) != 0, (String)translator.getMessage(ID.concat(".configuration.roleWithSymbolNotFound")).concat(" ").concat(roleInfo.getSymbol()));
            return role;
        }).collect(Collectors.toSet());
    }

    @Override
    public void createUser(User user, List<String> groupNames, List<String> positionIds) throws UserAlreadyExistException, GroupNotFoundException {
        this.userService.createUser(user, this.getGroupIds(groupNames), this.getPositionIds(positionIds));
    }

    private List<Long> getGroupIds(List<String> groupNames) {
        return groupNames.stream().map(groupName -> this.userGroupFinder.findByName(groupName, new String[0]).getObjectId()).collect(Collectors.toList());
    }

    private List<Long> getPositionIds(List<String> positionSymbols) {
        return positionSymbols.stream().filter(symbol -> !symbol.isEmpty()).map(symbol -> {
            Position position = this.positionFinder.findBySymbol(symbol, new String[0]);
            Assert.isTrue((position != null ? 1 : 0) != 0, (String)("Incorrect position symbol: " + symbol));
            return position.getId();
        }).collect(Collectors.toList());
    }

    @Override
    public void removeUser(String userName, String targetUserName, @NonNull OperationMode mode) {
        if (mode == null) {
            throw new NullPointerException("mode is marked non-null but is null");
        }
        if (StringUtils.isBlank((CharSequence)userName)) {
            throw new IllegalArgumentException("userName is blank");
        }
        if (StringUtils.isBlank((CharSequence)targetUserName)) {
            throw new IllegalArgumentException("targetUserName is blank");
        }
        User user = this.userFinder.findByUserName(userName, new String[0]);
        User targetUser = this.userFinder.findByUserName(targetUserName, new String[0]);
        if (user == null) {
            throw new UserNotFoundException(userName);
        }
        if (targetUser == null) {
            throw new UserNotFoundException(targetUserName);
        }
        if (targetUser.isActive().booleanValue()) {
            if (user.isActive() != null && user.isActive().booleanValue()) {
                this.userService.deactivateUser(this.deactivateUser(userName, targetUser));
            }
            if (mode == OperationMode.DELETE) {
                this.userService.deleteUser(userName);
            }
        } else {
            throw new IllegalArgumentException("Target user " + targetUserName + " is not active");
        }
    }

    public Deactivation deactivateUser(String userName, User targetUser) {
        Deactivation deactivation = Deactivation.create((String)userName);
        deactivation.setNotificationUser(targetUser);
        deactivation.setReportUser(targetUser);
        deactivation.setSubstitutionUser(targetUser);
        deactivation.setViewUser(targetUser);
        deactivation.setOtherAcitivitiesUser(targetUser);
        ArrayList<User> targetUserList = new ArrayList<User>();
        targetUserList.add(targetUser);
        deactivation.setUsers(targetUserList);
        return deactivation;
    }

    @Override
    public User findUserByLogin(String login) {
        return this.userFinder.findByUserName(login, new String[]{"groups", "positions"});
    }

    @Override
    public Set<Position> getPositions(String[] positionSymbols) {
        return Arrays.stream(positionSymbols).filter(symbol -> !symbol.isEmpty()).map(symbol -> {
            Position position = this.positionFinder.findBySymbol(symbol, new String[0]);
            Assert.isTrue((position != null ? 1 : 0) != 0, (String)("Incorrect position symbol: " + symbol));
            return position;
        }).collect(Collectors.toSet());
    }

    @Override
    public void updateUser(User user) {
        this.userService.updateUser(user);
    }

    @Override
    public void addUserToGroupsInNewTransaction(String login, List<String> groupList) {
        SharkUtils.runInNewTransaction(() -> IgnoringGroupNotFoundException.skipGroupNotFoundException(() -> this.userService.addUserToGroups(login, groupList)));
    }

    @Override
    public void removeGroup(String groupName) throws GroupNotFoundException {
        this.userService.deleteGroup(groupName);
    }
}

