/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.administrationtools.scheduledtask.utils;

import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskInstanceInfo;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.SortDirection;
import com.suncode.pwfl.search.Sorter;
import com.suncode.pwfl.search.sql.SQLBuilder;
import com.suncode.pwfl.search.sql.SQLFilter;
import com.suncode.pwfl.search.sql.SQLFinder;
import com.suncode.pwfl.search.sql.SimpleSQLFilter;
import com.suncode.pwfl.support.hibernate.type.StandardBasicTypes;
import com.suncode.pwfl.util.FinderFactory;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class PropertyInjector {
    private PropertyInjector() {
    }

    public static String injectLastSuccessfulExecutionTime(String replacedString, ScheduledTaskInstanceInfo scheduledTaskInstanceInfo) {
        String[] markers;
        block3: {
            block2: {
                markers = new String[]{"{timestamp}", "{DD}", "{MM}", "{YY}", "{YYYY}", "{hh}", "{mm}", "{ss}", "{nnn}"};
                if (StringUtils.isBlank((CharSequence)replacedString)) break block2;
                if (!Arrays.stream(markers).noneMatch(replacedString::contains)) break block3;
            }
            return replacedString;
        }
        SQLFinder finder = FinderFactory.getSQLFinder();
        SQLBuilder builder = new SQLBuilder();
        builder.setQuery("SELECT startdate FROM pm_scheduled_tasks_history");
        builder.addFilter((SQLFilter)new SimpleSQLFilter("taskid", (Object)scheduledTaskInstanceInfo.getId()));
        builder.addFilter((SQLFilter)new SimpleSQLFilter("success", (Object)true));
        builder.addSorter(new Sorter("startdate", SortDirection.DESC));
        builder.addScalar("startdate", StandardBasicTypes.TIMESTAMP);
        CountedResult data = finder.find(builder, Integer.valueOf(0), Integer.valueOf(1));
        Optional taskInfo = data.getData().stream().findFirst();
        Timestamp timestamp = taskInfo.isPresent() ? (Timestamp)((Map)taskInfo.get()).get("startdate") : new Timestamp(0L);
        return PropertyInjector.replaceTime(replacedString, markers, timestamp);
    }

    public static String injectCurrentTime(String replacedString) {
        String[] markers;
        block3: {
            block2: {
                markers = new String[]{"{current_timestamp}", "{current_DD}", "{current_MM}", "{current_YY}", "{current_YYYY}", "{current_hh}", "{current_mm}", "{current_ss}", "{current_nnn}"};
                if (StringUtils.isBlank((CharSequence)replacedString)) break block2;
                if (!Arrays.stream(markers).noneMatch(replacedString::contains)) break block3;
            }
            return replacedString;
        }
        Timestamp timestamp = Timestamp.from(Instant.now());
        return PropertyInjector.replaceTime(replacedString, markers, timestamp);
    }

    private static String replaceTime(String replacedString, String[] markers, Timestamp timestamp) {
        return replacedString.replace(markers[0], Long.toString(timestamp.getTime())).replace(markers[1], String.format("%02d", timestamp.toLocalDateTime().getDayOfMonth())).replace(markers[2], String.format("%02d", timestamp.toLocalDateTime().getMonthValue())).replace(markers[3], String.format("%02d", timestamp.toLocalDateTime().getYear()).substring(2)).replace(markers[4], Integer.toString(timestamp.toLocalDateTime().getYear())).replace(markers[5], String.format("%02d", timestamp.toLocalDateTime().getHour())).replace(markers[6], String.format("%02d", timestamp.toLocalDateTime().getMinute())).replace(markers[7], String.format("%02d", timestamp.toLocalDateTime().getSecond())).replace(markers[8], String.format("%03d", timestamp.toLocalDateTime().getNano() / 1000000));
    }
}

