/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.administrationtools.scheduledtask;

import com.suncode.plugin.administrationtools.Categories;
import com.suncode.plugin.administrationtools.scheduledtask.enums.OperationMode;
import com.suncode.plugin.administrationtools.scheduledtask.exception.CancelTaskException;
import com.suncode.plugin.administrationtools.scheduledtask.exception.InvalidDatasourceIDException;
import com.suncode.plugin.administrationtools.scheduledtask.exception.util.ExceptionUtils;
import com.suncode.plugin.administrationtools.scheduledtask.json.JsonConverter;
import com.suncode.plugin.administrationtools.scheduledtask.summary.TaskSummary;
import com.suncode.plugin.administrationtools.scheduledtask.utils.PropertyInjector;
import com.suncode.plugin.administrationtools.service.UserManagementService;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskDefinitionBuilder;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskInstanceInfo;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTask;
import com.suncode.pwfl.administration.scheduledtask.context.CancelationHandler;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.datasource.DataSourceInstance;
import com.suncode.pwfl.datasource.DataSourceService;
import com.suncode.pwfl.util.SpringContext;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Transactional
@ScheduledTask
public class RemoveUsersTask {
    private static final Logger log = LoggerFactory.getLogger(RemoveUsersTask.class);
    private static final String DATASOURCE_PARAM_USERNAME_ID = "username";
    private static final String DATASOURCE_PARAM_TARGET_USERNAME_ID = "targetUserName";
    private static final String ADMIN_USERNAME = "admin";
    private final DataSourceService dataSourceService = (DataSourceService)SpringContext.getBean(DataSourceService.class);
    @Autowired
    private UserManagementService userManagementService;

    @Define
    public void definition(ScheduledTaskDefinitionBuilder builder) {
        ((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)builder.id("plus-administration-tools.remove-users.scheduled-task")).name("scheduled-task.remove-users.name")).description("scheduled-task.remove-users.desc")).category(new Category[]{Categories.USER_MANAGEMENT})).cancelable().parameter().id("datasourceId").name("scheduled-task.remove-users.datasource-id.name").description("scheduled-task.remove-users.datasource-id.desc").type((Type)Types.STRING).create()).parameter().id("operationMode").name("scheduled-task.remove-users.operation-mode.name").description("scheduled-task.remove-users.operation-mode.desc").type((Type)Types.STRING).defaultValue((Object)"DEACTIVATION").create()).parameter().id("jsonDatasourceParameters").name("scheduled-task.remove-users.json-datasource-parameters.name").description("scheduled-task.remove-users.json-datasource-parameters.desc").type((Type)Types.STRING).optional().create()).parameter().id("defaultTargetUserName").name("scheduled-task.remove-users.default-target-username.name").description("scheduled-task.remove-users.default-target-username.desc").type((Type)Types.STRING).optional().create();
    }

    public String execute(@Param String datasourceId, @Param String jsonDatasourceParameters, @Param String defaultTargetUserName, @Param String operationMode, ScheduledTaskInstanceInfo scheduledTaskInstanceInfo, CancelationHandler cancelationHandler, org.apache.log4j.Logger taskLog) {
        taskLog.debug((Object)("Start task: " + scheduledTaskInstanceInfo.getName()));
        TaskSummary taskSummary = new TaskSummary(taskLog);
        try {
            OperationMode opMode = OperationMode.getOperationMode(operationMode);
            List<Map<String, Object>> usersToRemove = this.datasourceExecute(datasourceId, jsonDatasourceParameters, scheduledTaskInstanceInfo, cancelationHandler);
            taskSummary.setTotal(usersToRemove.size());
            usersToRemove.forEach(userToRemove -> {
                ExceptionUtils.checkTaskCancellation(cancelationHandler);
                Assert.isTrue((boolean)userToRemove.containsKey(DATASOURCE_PARAM_USERNAME_ID), (String)("No output parameter for id username for datasource id " + datasourceId));
                String userName = String.valueOf(userToRemove.get(DATASOURCE_PARAM_USERNAME_ID));
                String targetUserName = this.getTargetUserName(defaultTargetUserName, (Map<String, Object>)userToRemove);
                try {
                    this.userManagementService.removeUser(userName, targetUserName, opMode);
                    taskSummary.logDebug("User '" + userName + "' was " + operationMode.toLowerCase());
                    taskSummary.incrementSuccess();
                }
                catch (Exception e) {
                    taskSummary.logError(operationMode + " for userName: '" + userName + "' target userName: '" + targetUserName + "'", e);
                    taskSummary.incrementErrors();
                }
            });
        }
        catch (CancelTaskException cTE) {
            taskLog.debug((Object)"Cancel By user");
            String string = "Cancel By user. " + taskSummary.summary();
            return string;
        }
        catch (Exception e) {
            taskLog.error((Object)"ERROR", (Throwable)e);
            throw e;
        }
        finally {
            taskLog.debug((Object)("All users form datasource: " + taskSummary.getTotal()));
            taskLog.debug((Object)(operationMode + " users: " + taskSummary.getSuccess()));
            taskLog.debug((Object)("Error processed" + taskSummary.getErrors()));
            taskLog.debug((Object)("Not processed:  " + taskSummary.getNotProcessedCount()));
            taskLog.debug((Object)("End task: " + scheduledTaskInstanceInfo.getName()));
        }
        return taskSummary.summary();
    }

    private List<Map<String, Object>> datasourceExecute(String datasourceId, String jsonDatasourceParameters, ScheduledTaskInstanceInfo scheduledTaskInstanceInfo, CancelationHandler cancelationHandler) {
        DataSourceInstance dataSourceInstance = this.dataSourceService.getDataSource(datasourceId);
        if (dataSourceInstance == null) {
            throw new InvalidDatasourceIDException("Wrong datasource ID!: " + datasourceId);
        }
        Map<String, String> values = this.injectProperties(jsonDatasourceParameters, scheduledTaskInstanceInfo);
        ExceptionUtils.checkTaskCancellation(cancelationHandler);
        List usersToRemove = dataSourceInstance.execute(values, null).getData();
        log.debug("Data size from datasource:" + usersToRemove.size());
        return usersToRemove;
    }

    private String getTargetUserName(String defaultTargetUserName, Map<String, Object> userToRemove) {
        String targetUserName = userToRemove.containsKey(DATASOURCE_PARAM_TARGET_USERNAME_ID) ? String.valueOf(userToRemove.get(DATASOURCE_PARAM_TARGET_USERNAME_ID)) : defaultTargetUserName;
        return StringUtils.isNotBlank((CharSequence)targetUserName) ? targetUserName : ADMIN_USERNAME;
    }

    private Map<String, String> injectProperties(String json, ScheduledTaskInstanceInfo scheduledTaskInstanceInfo) {
        return JsonConverter.convertJsonToMap(json).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, this.injectScheduledTaskProperty(scheduledTaskInstanceInfo)));
    }

    private Function<Map.Entry<String, String>, String> injectScheduledTaskProperty(ScheduledTaskInstanceInfo scheduledTaskInstanceInfo) {
        return entryMap -> {
            String value = PropertyInjector.injectLastSuccessfulExecutionTime((String)entryMap.getValue(), scheduledTaskInstanceInfo);
            return PropertyInjector.injectCurrentTime(value);
        };
    }
}

