/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.administrationtools.autotask;

import com.suncode.plugin.administrationtools.Categories;
import com.suncode.plugin.administrationtools.exception.AdministrationToolsException;
import com.suncode.plugin.administrationtools.exception.message.ErrorMessage;
import com.suncode.plugin.administrationtools.service.UserManagementService;
import com.suncode.plugin.administrationtools.support.SharkUtils;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.variablesetter.annotation.VariableSetter;
import com.suncode.pwfl.workflow.invocable.CommonDefinitionBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

@Application
@VariableSetter
@ComponentsFormScript(value="scripts/dynamic-form-pwe/remove-user-from-group.js")
public class RemoveUserFromGroup {
    private static final Logger log = LoggerFactory.getLogger(RemoveUserFromGroup.class);
    @Autowired
    private UserManagementService userManagementService;

    @Define
    public void definition(CommonDefinitionBuilder builder) {
        ((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)builder.id("remove-user-from-group")).name("application.remove-user-from-group.name")).description("application.remove-user-from-group.desc")).category(new Category[]{Categories.USER_MANAGEMENT})).icon((Icon)SilkIconPack.GROUP_DELETE)).parameter().id("login").name("application.remove-user-from-group.login.name").type((Type)Types.STRING).optional().create()).parameter().id("userLogins").name("application.add-user-to-group.param.userLogins.name").type((Type)Types.STRING_ARRAY).optional().create()).parameter().id("groupNames").name("application.remove-user-from-group.group-names.name").type((Type)Types.STRING_ARRAY).create();
    }

    public void execute(@Param String login, @Param String[] userLogins, @Param String[] groupNames) {
        this.run(login, userLogins, groupNames);
    }

    public void set(@Param String login, @Param String[] userLogins, @Param String[] groupNames) {
        this.run(login, userLogins, groupNames);
    }

    private void run(String login, String[] userLogins, String[] groupNames) {
        List<String> loginList = this.arrayToList(userLogins);
        if (!StringUtils.isBlank((CharSequence)login) && !loginList.contains(login)) {
            loginList.add(login);
        }
        Assert.isTrue((!loginList.isEmpty() ? 1 : 0) != 0, (String)"Login list is empty. Nothing to remove.");
        List<String> groupList = this.arrayToList(groupNames);
        Assert.isTrue((!groupList.isEmpty() ? 1 : 0) != 0, (String)"Group list is empty. Nothing to remove.");
        loginList.forEach(userLogin -> this.removeUserFromGroup((String)userLogin, groupList));
    }

    private List<String> arrayToList(String[] array) {
        return Arrays.asList(array).stream().filter(StringUtils::isNotEmpty).distinct().collect(Collectors.toList());
    }

    private void removeUserFromGroup(String login, List<String> groupList) {
        if (!this.userManagementService.isUserExist(login)) {
            throw new AdministrationToolsException(ErrorMessage.USER_MANAGEMENT, String.join((CharSequence)"", "User \"", login, "\" not exist"));
        }
        SharkUtils.runInNewTransaction(() -> this.userManagementService.removeUserFromGroups(login, groupList));
        log.debug(String.join((CharSequence)" ", "User", login, "has been remove from groups:", String.join((CharSequence)", ", groupList)));
    }
}

