/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.administrationtools.autotask;

import com.suncode.plugin.administrationtools.Categories;
import com.suncode.plugin.administrationtools.autotask.parameters.CreatePositionParameters;
import com.suncode.plugin.administrationtools.dto.PositionInfo;
import com.suncode.plugin.administrationtools.dto.RoleInfo;
import com.suncode.plugin.administrationtools.service.UserManagementService;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.Parameters;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.translation.Translator;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.exception.AcceptanceException;
import com.suncode.pwfl.workflow.form.variablesetter.annotation.VariableSetter;
import com.suncode.pwfl.workflow.invocable.CommonDefinitionBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

@Application
@VariableSetter
@ComponentsFormScript(value="scripts/dynamic-form-pwe/create-position-form.js")
public class CreatePosition {
    private static final Logger log = LoggerFactory.getLogger(CreatePosition.class);
    private static final String ID = "plusadministrationtools.autotask.CreatePosition";
    @Autowired
    private UserManagementService userManagementService;

    @Define
    public void definition(CommonDefinitionBuilder builder) {
        ((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)builder.id("create-position")).name("application.create-position.name")).description("application.create-position.desc")).category(new Category[]{Categories.USER_MANAGEMENT})).icon((Icon)SilkIconPack.NEW)).parameter().id("name").name(ID.concat(".configuration.param.name.name")).description(ID.concat(".configuration.param.name.desc")).type((Type)Types.STRING).create()).parameter().id("symbol").name(ID.concat(".configuration.param.symbol.name")).description(ID.concat(".configuration.param.symbol.desc")).type((Type)Types.STRING).create()).parameter().id("overridingPositionSymbol").optional().name(ID.concat(".configuration.param.overridingPositionSymbol.name")).description(ID.concat(".configuration.param.overridingPositionSymbol.desc")).type((Type)Types.STRING).create()).parameter().id("unitSymbol").optional().name(ID.concat(".configuration.param.unitSymbol.name")).description(ID.concat(".configuration.param.unitSymbol.desc")).type((Type)Types.STRING).create()).parameter().id("roleSymbols").optional().name(ID.concat(".configuration.param.roleSymbols.name")).description(ID.concat(".configuration.param.roleSymbols.desc")).type((Type)Types.STRING_ARRAY).create()).parameter().id("existingPositionModification").name(ID.concat(".configuration.param.existingPositionModification.name")).description(ID.concat(".configuration.param.existingPositionModification.desc")).type((Type)Types.BOOLEAN).defaultValue((Object)false).create()).parameter().id("overridingPositionSymbolSavingSettings").optional().name(ID.concat(".configuration.param.overridingPositionSymbolSavingSettings.name")).type((Type)Types.STRING).create()).parameter().id("unitSymbolSavingSettings").optional().name(ID.concat(".configuration.param.unitSymbolSavingSettings.name")).type((Type)Types.STRING).create()).parameter().id("roleSymbolsSavingSettings").optional().name(ID.concat(".configuration.param.roleSymbolsSavingSettings.name")).type((Type)Types.STRING).create();
    }

    public void execute(Parameters parameters, Translator translator) throws AcceptanceException {
        this.run(parameters, translator);
    }

    public void set(Parameters parameters, Translator translator) throws AcceptanceException {
        this.run(parameters, translator);
    }

    public void run(Parameters parameters, Translator translator) throws AcceptanceException {
        CreatePositionParameters positionParameters = new CreatePositionParameters(parameters);
        try {
            Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)positionParameters.getName()), (String)translator.getMessage(ID.concat(".configuration.emptyPositionName")));
            Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)positionParameters.getSymbol()), (String)translator.getMessage(ID.concat(".configuration.emptyPositionSymbol")));
            PositionInfo positionInfo = PositionInfo.builder().name(positionParameters.getName()).symbol(positionParameters.getSymbol()).unitSymbol(positionParameters.getUnitSymbol()).overridingPositionSymbol(positionParameters.getOverridingPositionSymbol()).roleInfos(this.getRolesInfo(positionParameters.getRoleSymbols())).build();
            if (positionParameters.getExistingPositionModification().booleanValue()) {
                this.userManagementService.updatePosition(positionParameters.getOverridingPositionSymbolSavingSettings(), positionParameters.getUnitSymbolSavingSettings(), positionParameters.getRoleSymbolsSavingSettings(), positionInfo, translator);
            } else {
                this.userManagementService.createPosition(positionInfo, translator);
            }
            log.debug(String.join((CharSequence)" ", "Position has been added/updated. Name:", positionParameters.getName(), ", Symbol:", positionParameters.getSymbol(), ", overriding position symbol:", positionParameters.getOverridingPositionSymbol(), ", unit symbol:", positionParameters.getUnitSymbol(), ", roles:", String.join((CharSequence)", ", positionParameters.getRoleSymbols())));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new AcceptanceException(e.getMessage());
        }
    }

    private List<RoleInfo> getRolesInfo(String[] roleSymbols) {
        return Arrays.stream(roleSymbols).map(roleSymbol -> {
            if (!roleSymbol.isEmpty()) {
                return this.decodeRoleSymbol((String)roleSymbol);
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public RoleInfo decodeRoleSymbol(String roleSymbol) {
        String[] splitElements = roleSymbol.split(":");
        Assert.isTrue((splitElements.length == 3 ? 1 : 0) != 0, (String)String.join((CharSequence)"", "Role \"", roleSymbol, "\" is incorrect. Correct format: packageId:procDefId:roleId"));
        return RoleInfo.builder().packageId(splitElements[0]).processDefId(splitElements[1]).roleId(splitElements[2]).symbol(roleSymbol).build();
    }
}

