/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.administrationtools.autotask;

import com.suncode.plugin.administrationtools.Categories;
import com.suncode.plugin.administrationtools.service.UserManagementService;
import com.suncode.plugin.administrationtools.support.SharkUtils;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.variablesetter.annotation.VariableSetter;
import com.suncode.pwfl.workflow.invocable.CommonDefinitionBuilder;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Application
@VariableSetter
@ComponentsFormScript(value="scripts/dynamic-form-pwe/create-group-form.js")
public class CreateGroup {
    private static final Logger log = LoggerFactory.getLogger(CreateGroup.class);
    @Autowired
    private UserManagementService userManagementService;

    @Define
    public void definition(CommonDefinitionBuilder builder) {
        ((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)builder.id("create-group")).name("application.create-group.name")).description("application.create-group.desc")).category(new Category[]{Categories.USER_MANAGEMENT})).icon((Icon)SilkIconPack.NEW)).parameter().id("name").name("application.create-group.param.name.name").type((Type)Types.STRING_ARRAY).create()).parameter().id("description").optional().name("application.create-group.param.description.name").type((Type)Types.STRING_ARRAY).create();
    }

    public void execute(@Param String[] name, @Param String[] description) {
        SharkUtils.runInNewTransaction(() -> this.run(name, description));
    }

    public void set(@Param String[] name, @Param String[] description) {
        SharkUtils.runInNewTransaction(() -> this.run(name, description));
    }

    private void run(String[] name, String[] description) {
        ArrayList<String> createdGroups = new ArrayList<String>();
        for (int groupNo = 0; groupNo < name.length; ++groupNo) {
            if (name[groupNo].isEmpty() || createdGroups.contains(name[groupNo]) || !this.userManagementService.createGroupIfNotExist(name[groupNo], description[groupNo])) continue;
            createdGroups.add(name[groupNo]);
        }
        if (createdGroups.isEmpty()) {
            log.debug("No new group has been created");
        } else {
            log.debug("Created groups: " + String.join((CharSequence)", ", createdGroups));
        }
    }
}

