/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.administrationtools.autotask;

import com.suncode.plugin.administrationtools.Categories;
import com.suncode.pwfl.calendar.resource.CalendarResourceGroupFacade;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.function.FunctionCall;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.DivanteIcon;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.component.ContextVariables;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.variablesetter.annotation.VariableSetter;
import com.suncode.pwfl.workflow.invocable.CommonDefinitionBuilder;
import com.suncode.pwfl.workflow.variable.Variable;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

@Application
@VariableSetter
@ComponentsFormScript(value="scripts/dynamic-form-pwe/create-calendar-resource-group.js")
public class CreateCalendarResourceGroup {
    private static final Logger log = LoggerFactory.getLogger(CreateCalendarResourceGroup.class);
    @Autowired
    private CalendarResourceGroupFacade calendarResourceGroupFacade;

    @Define
    public void definition(CommonDefinitionBuilder builder) {
        ((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)builder.id("create-calendar-resource-group")).name("application.create-calendar-resource-group.name")).description("application.create-calendar-resource-group.desc")).category(new Category[]{Categories.TOOLS_CALENDAR})).documentationLink("https://plusworkflow.helpdocsonline.com/{PROPROFS_LANGUAGE}creating-resource-groups")).icon((Icon)DivanteIcon.CALENDAR)).parameter().id("names").name("application.create-calendar-resource-group.param.name.name").description("application.create-calendar-resource-group.param.name.desc").type((Type)Types.STRING_ARRAY).create()).parameter().id("descriptions").name("application.create-calendar-resource-group.param.description.name").description("application.create-calendar-resource-group.param.description.desc").type((Type)Types.STRING_ARRAY).optional().create()).parameter().id("parentResourceGroupId").name("application.create-calendar-resource-group.param.parent-resource-group-id.name").description("application.create-calendar-resource-group.param.parent-resource-group-id.desc").type((Type)Types.INTEGER_ARRAY).optional().create()).parameter().id("targetVariable").name("application.create-calendar-resource-group.param.target-variable.name").description("application.create-calendar-resource-group.param.target-variable.desc").type((Type)Types.VARIABLE).optional().create()).parameter().id("value").name("application.create-calendar-resource-group.param.value.name").description("application.create-calendar-resource-group.param.value.desc").type((Type)Types.FUNCTION).optional().create()).contextVariable().id("returnValue").name("application.create-calendar-resource-group.context-variable.return-value.name").description("application.create-calendar-resource-group.context-variable.return-value.desc").type((Type)Types.INTEGER_ARRAY).create();
    }

    public void execute(@Param String[] names, @Param String[] descriptions, @Param Long[] parentResourceGroupId, @Param Variable targetVariable, @Param FunctionCall value, ContextVariables contextVariables) {
        this.run(names, descriptions, parentResourceGroupId, targetVariable, value, contextVariables);
    }

    public void set(@Param String[] names, @Param String[] descriptions, @Param Long[] parentResourceGroupId, @Param Variable targetVariable, @Param FunctionCall value, ContextVariables contextVariables) {
        this.run(names, descriptions, parentResourceGroupId, targetVariable, value, contextVariables);
    }

    private void run(String[] names, String[] descriptions, Long[] parentResourceGroupId, Variable targetVariable, FunctionCall value, ContextVariables contextVariables) {
        Assert.notEmpty((Object[])names, (String)"Names parameter is required");
        int namesLength = names.length;
        if (parentResourceGroupId != null) {
            Assert.isTrue((parentResourceGroupId.length == namesLength ? 1 : 0) != 0, (String)String.format("Parent resource group IDs array must have the same length as names array. Expected: %d, got: %d", namesLength, parentResourceGroupId.length));
        }
        if (descriptions != null) {
            Assert.isTrue((descriptions.length == namesLength ? 1 : 0) != 0, (String)String.format("Descriptions array must have the same length as names array. Expected: %d, got: %d", namesLength, descriptions.length));
        }
        String[] normalizedDescriptions = new String[namesLength];
        Long[] normalizedParentResourceGroupIds = new Long[namesLength];
        for (int i = 0; i < namesLength; ++i) {
            Assert.hasText((String)names[i], (String)String.format("Name at index %d cannot be empty or blank", i));
            normalizedParentResourceGroupIds[i] = parentResourceGroupId != null && parentResourceGroupId[i] != null && parentResourceGroupId[i] > 0L ? parentResourceGroupId[i] : null;
            normalizedDescriptions[i] = descriptions != null && descriptions[i] != null ? descriptions[i] : "";
        }
        ArrayList<Long> createdIds = new ArrayList<Long>();
        for (int i = 0; i < namesLength; ++i) {
            String groupName = names[i];
            String descriptionValue = normalizedDescriptions[i];
            Long parentResourceGroupIdValue = normalizedParentResourceGroupIds[i];
            try {
                log.debug("Creating calendar resource group with name: {}", (Object)groupName);
                long resourceGroupId = this.calendarResourceGroupFacade.createCalendarResourceGroup(groupName, descriptionValue, parentResourceGroupIdValue);
                createdIds.add(resourceGroupId);
                log.debug("Calendar resource group created successfully with ID: {}", (Object)resourceGroupId);
                continue;
            }
            catch (Exception e) {
                log.error("Error creating calendar resource group with name: {}", (Object)groupName, (Object)e);
                createdIds.add(0L);
            }
        }
        if (contextVariables != null) {
            Long[] idsArray = createdIds.toArray(new Long[0]);
            contextVariables.set("returnValue", (Object)idsArray);
        }
        if (targetVariable != null && value != null) {
            targetVariable.setValue(value.call());
        }
    }
}

