/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.administrationtools.autotask;

import com.suncode.plugin.administrationtools.Categories;
import com.suncode.pwfl.calendar.resource.CalendarResourceFacade;
import com.suncode.pwfl.calendar.resource.CalendarResourceOverlappingEventsOptions;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.function.FunctionCall;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.DivanteIcon;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.component.ContextVariables;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.variablesetter.annotation.VariableSetter;
import com.suncode.pwfl.workflow.invocable.CommonDefinitionBuilder;
import com.suncode.pwfl.workflow.variable.Variable;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

@Application
@VariableSetter
@ComponentsFormScript(value="scripts/dynamic-form-pwe/create-calendar-resource.js")
public class CreateCalendarResource {
    private static final Logger log = LoggerFactory.getLogger(CreateCalendarResource.class);
    @Autowired
    private CalendarResourceFacade calendarResourceFacade;

    @Define
    public void definition(CommonDefinitionBuilder builder) {
        ((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)builder.id("create-calendar-resource")).name("application.create-calendar-resource.name")).description("application.create-calendar-resource.desc")).category(new Category[]{Categories.TOOLS_CALENDAR})).documentationLink("https://plusworkflow.helpdocsonline.com/{PROPROFS_LANGUAGE}resource-creation")).icon((Icon)DivanteIcon.CALENDAR)).parameter().id("names").name("application.create-calendar-resource.param.name.name").description("application.create-calendar-resource.param.name.desc").type((Type)Types.STRING_ARRAY).create()).parameter().id("descriptions").name("application.create-calendar-resource.param.description.name").description("application.create-calendar-resource.param.description.desc").type((Type)Types.STRING_ARRAY).optional().create()).parameter().id("resourceGroupIds").name("application.create-calendar-resource.param.resource-group-id.name").description("application.create-calendar-resource.param.resource-group-id.desc").type((Type)Types.INTEGER_ARRAY).create()).parameter().id("allowOverlappingEvents").name("application.create-calendar-resource.param.allow-overlapping-events.name").description("application.create-calendar-resource.param.allow-overlapping-events.desc").type((Type)Types.STRING_ARRAY).create()).parameter().id("targetVariable").name("application.create-calendar-resource.param.target-variable.name").description("application.create-calendar-resource.param.target-variable.desc").type((Type)Types.VARIABLE).optional().create()).parameter().id("value").name("application.create-calendar-resource.param.value.name").description("application.create-calendar-resource.param.value.desc").type((Type)Types.FUNCTION).optional().create()).contextVariable().id("returnValue").name("application.create-calendar-resource.context-variable.return-value.name").description("application.create-calendar-resource.context-variable.return-value.desc").type((Type)Types.INTEGER_ARRAY).create();
    }

    public void execute(@Param String[] names, @Param String[] descriptions, @Param Long[] resourceGroupIds, @Param String[] allowOverlappingEvents, @Param Variable targetVariable, @Param FunctionCall value, ContextVariables contextVariables) {
        this.run(names, descriptions, resourceGroupIds, allowOverlappingEvents, targetVariable, value, contextVariables);
    }

    public void set(@Param String[] names, @Param String[] descriptions, @Param Long[] resourceGroupIds, @Param String[] allowOverlappingEvents, @Param Variable targetVariable, @Param FunctionCall value, ContextVariables contextVariables) {
        this.run(names, descriptions, resourceGroupIds, allowOverlappingEvents, targetVariable, value, contextVariables);
    }

    private void run(String[] names, String[] descriptions, Long[] resourceGroupIds, String[] allowOverlappingEvents, Variable targetVariable, FunctionCall value, ContextVariables contextVariables) {
        Assert.notEmpty((Object[])names, (String)"Names parameter is required");
        Assert.notEmpty((Object[])allowOverlappingEvents, (String)"Allow overlapping events parameter is required");
        Assert.notEmpty((Object[])resourceGroupIds, (String)"Resource group IDs parameter is required");
        int namesLength = names.length;
        Assert.isTrue((allowOverlappingEvents.length == namesLength && resourceGroupIds.length == namesLength ? 1 : 0) != 0, (String)String.format("All arrays must have the same length as names array (%d). Got: allowOverlappingEvents=%d, resourceGroupIds=%d", namesLength, allowOverlappingEvents.length, resourceGroupIds.length));
        if (descriptions != null) {
            Assert.isTrue((descriptions.length == namesLength ? 1 : 0) != 0, (String)String.format("Descriptions array must have the same length as names array. Expected: %d, got: %d", namesLength, descriptions.length));
        }
        String[] normalizedDescriptions = new String[namesLength];
        for (int i = 0; i < namesLength; ++i) {
            Assert.hasText((String)names[i], (String)String.format("Name at index %d cannot be empty or blank", i));
            Assert.hasText((String)allowOverlappingEvents[i], (String)String.format("Allow overlapping events at index %d cannot be empty or blank", i));
            String overlappingEventsUpper = allowOverlappingEvents[i].toUpperCase();
            Assert.isTrue((overlappingEventsUpper.equals(CalendarResourceOverlappingEventsOptions.ALWAYS.name()) || overlappingEventsUpper.equals(CalendarResourceOverlappingEventsOptions.NEVER.name()) || overlappingEventsUpper.equals(CalendarResourceOverlappingEventsOptions.WARNING.name()) ? 1 : 0) != 0, (String)String.format("Allow overlapping events at index %d must be one of: ALWAYS, NEVER, WARNING. Got: %s", i, allowOverlappingEvents[i]));
            Assert.isTrue((resourceGroupIds[i] != null && resourceGroupIds[i] > 0L ? 1 : 0) != 0, (String)String.format("Resource group ID at index %d must be positive, got: %s", i, resourceGroupIds[i]));
            normalizedDescriptions[i] = descriptions != null && descriptions[i] != null ? descriptions[i] : "";
        }
        ArrayList<Long> createdResourceIds = new ArrayList<Long>();
        for (int i = 0; i < namesLength; ++i) {
            String resourceName = names[i];
            String descriptionValue = normalizedDescriptions[i];
            Long resourceGroupIdValue = resourceGroupIds[i];
            CalendarResourceOverlappingEventsOptions overlappingOption = CalendarResourceOverlappingEventsOptions.valueOf((String)allowOverlappingEvents[i].toUpperCase());
            try {
                log.debug("Creating calendar resource with name: {}", (Object)resourceName);
                long resourceId = this.calendarResourceFacade.createCalendarResource(resourceName, descriptionValue, resourceGroupIdValue, overlappingOption);
                createdResourceIds.add(resourceId);
                log.debug("Calendar resource created successfully with ID: {}", (Object)resourceId);
                continue;
            }
            catch (Exception e) {
                log.error("Error creating calendar resource with name: {}", (Object)resourceName, (Object)e);
                createdResourceIds.add(0L);
            }
        }
        if (contextVariables != null) {
            Long[] idsArray = createdResourceIds.toArray(new Long[0]);
            contextVariables.set("returnValue", (Object)idsArray);
        }
        if (targetVariable != null && value != null) {
            targetVariable.setValue(value.call());
        }
    }
}

