/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.administrationtools.autotask;

import com.suncode.plugin.administrationtools.Categories;
import com.suncode.pwfl.calendar.resource.CalendarResourceFacade;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.function.FunctionCall;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.DivanteIcon;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.component.ContextVariables;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.variablesetter.annotation.VariableSetter;
import com.suncode.pwfl.workflow.invocable.CommonDefinitionBuilder;
import com.suncode.pwfl.workflow.variable.Variable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

@Application
@VariableSetter
@ComponentsFormScript(value="scripts/dynamic-form-pwe/add-calendar-resource-permission.js")
public class AddCalendarResourcePermission {
    private static final Logger log = LoggerFactory.getLogger(AddCalendarResourcePermission.class);
    @Autowired
    private CalendarResourceFacade calendarResourceFacade;

    @Define
    public void definition(CommonDefinitionBuilder builder) {
        ((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)builder.id("add-calendar-resource-permission")).name("application.add-calendar-resource-permission.name")).description("application.add-calendar-resource-permission.desc")).category(new Category[]{Categories.TOOLS_CALENDAR})).documentationLink("https://plusworkflow.helpdocsonline.com/{PROPROFS_LANGUAGE}adding-permissions-to-resources")).icon((Icon)DivanteIcon.CALENDAR)).parameter().id("resourceId").name("application.add-calendar-resource-permission.param.resource-id.name").description("application.add-calendar-resource-permission.param.resource-id.desc").type((Type)Types.INTEGER).create()).parameter().id("permissionType").name("application.add-calendar-resource-permission.param.permission-type.name").description("application.add-calendar-resource-permission.param.permission-type.desc").type((Type)Types.STRING).defaultValue((Object)"USER").create()).parameter().id("usernames").name("application.add-calendar-resource-permission.param.usernames.name").description("application.add-calendar-resource-permission.param.usernames.desc").type((Type)Types.STRING_ARRAY).optional().create()).parameter().id("groupNames").name("application.add-calendar-resource-permission.param.group-names.name").description("application.add-calendar-resource-permission.param.group-names.desc").type((Type)Types.STRING_ARRAY).optional().create()).parameter().id("targetVariable").name("application.add-calendar-resource-permission.param.target-variable.name").description("application.add-calendar-resource-permission.param.target-variable.desc").type((Type)Types.VARIABLE).optional().create()).parameter().id("value").name("application.add-calendar-resource-permission.param.value.name").description("application.add-calendar-resource-permission.param.value.desc").type((Type)Types.FUNCTION).optional().create()).contextVariable().id("returnValue").name("application.add-calendar-resource-permission.context-variable.return-value.name").description("application.add-calendar-resource-permission.context-variable.return-value.desc").type((Type)Types.INTEGER_ARRAY).create();
    }

    public void execute(@Param Long resourceId, @Param String permissionType, @Param String[] usernames, @Param String[] groupNames, @Param Variable targetVariable, @Param FunctionCall value, ContextVariables contextVariables) {
        this.run(resourceId, permissionType, usernames, groupNames, targetVariable, value, contextVariables);
    }

    public void set(@Param Long resourceId, @Param String permissionType, @Param String[] usernames, @Param String[] groupNames, @Param Variable targetVariable, @Param FunctionCall value, ContextVariables contextVariables) {
        this.run(resourceId, permissionType, usernames, groupNames, targetVariable, value, contextVariables);
    }

    private void run(Long resourceId, String permissionType, String[] usernames, String[] groupNames, Variable targetVariable, FunctionCall value, ContextVariables contextVariables) {
        Assert.isTrue((resourceId != null && resourceId > 0L ? 1 : 0) != 0, (String)"Resource ID is required and must be positive");
        Assert.hasText((String)permissionType, (String)"Permission type is required");
        boolean isUserType = "USER".equalsIgnoreCase(permissionType);
        boolean isGroupType = "GROUP".equalsIgnoreCase(permissionType);
        Assert.isTrue((isUserType || isGroupType ? 1 : 0) != 0, (String)"Permission type must be either 'USER' or 'GROUP'");
        if (isUserType) {
            Assert.notEmpty((Object[])usernames, (String)"Usernames array is required when permission type is USER");
        } else {
            Assert.notEmpty((Object[])groupNames, (String)"Group names array is required when permission type is GROUP");
        }
        ArrayList<Long> createdShareIds = new ArrayList<Long>();
        if (isUserType) {
            List<String> usernameList = this.arrayToList(usernames);
            for (String username : usernameList) {
                try {
                    log.debug("Adding permission for user '{}' to resource with ID: {}", (Object)username, (Object)resourceId);
                    long shareId = this.calendarResourceFacade.createCalendarResourceShareForUser(resourceId.longValue(), username);
                    createdShareIds.add(shareId);
                    log.debug("Permission added successfully for user '{}' to resource ID: {}, share ID: {}", new Object[]{username, resourceId, shareId});
                }
                catch (Exception e) {
                    log.error("Error adding permission for user '{}' to resource ID {}: {}", new Object[]{username, resourceId, e.getMessage(), e});
                    createdShareIds.add(0L);
                }
            }
        } else {
            List<String> groupNameList = this.arrayToList(groupNames);
            for (String groupName : groupNameList) {
                try {
                    log.debug("Adding permission for group '{}' to resource with ID: {}", (Object)groupName, (Object)resourceId);
                    long shareId = this.calendarResourceFacade.createCalendarResourceShareForGroup(resourceId.longValue(), groupName);
                    createdShareIds.add(shareId);
                    log.debug("Permission added successfully for group '{}' to resource ID: {}, share ID: {}", new Object[]{groupName, resourceId, shareId});
                }
                catch (Exception e) {
                    log.error("Error adding permission for group '{}' to resource ID {}: {}", new Object[]{groupName, resourceId, e.getMessage(), e});
                    createdShareIds.add(0L);
                }
            }
        }
        if (contextVariables != null) {
            Long[] idsArray = createdShareIds.toArray(new Long[0]);
            contextVariables.set("returnValue", (Object)idsArray);
        }
        if (targetVariable != null && value != null) {
            targetVariable.setValue(value.call());
        }
    }

    private List<String> arrayToList(String[] array) {
        if (array == null) {
            return new ArrayList<String>();
        }
        return Arrays.stream(array).filter(StringUtils::isNotBlank).distinct().collect(Collectors.toList());
    }
}

