/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.administrationtools.autotask;

import com.suncode.plugin.administrationtools.Categories;
import com.suncode.pwfl.calendar.resource.CalendarResourceGroupFacade;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.function.FunctionCall;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.DivanteIcon;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.component.ContextVariables;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.variablesetter.annotation.VariableSetter;
import com.suncode.pwfl.workflow.invocable.CommonDefinitionBuilder;
import com.suncode.pwfl.workflow.variable.Variable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

@Application
@VariableSetter
@ComponentsFormScript(value="scripts/dynamic-form-pwe/add-calendar-resource-group-permission.js")
public class AddCalendarResourceGroupPermission {
    private static final Logger log = LoggerFactory.getLogger(AddCalendarResourceGroupPermission.class);
    @Autowired
    private CalendarResourceGroupFacade calendarResourceGroupFacade;

    @Define
    public void definition(CommonDefinitionBuilder builder) {
        ((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)builder.id("add-calendar-resource-group-permission")).name("application.add-calendar-resource-group-permission.name")).description("application.add-calendar-resource-group-permission.desc")).category(new Category[]{Categories.TOOLS_CALENDAR})).documentationLink("https://plusworkflow.helpdocsonline.com/{PROPROFS_LANGUAGE}adding-permissions-to-resource-groups")).icon((Icon)DivanteIcon.CALENDAR)).parameter().id("resourceGroupId").name("application.add-calendar-resource-group-permission.param.resource-group-id.name").description("application.add-calendar-resource-group-permission.param.resource-group-id.desc").type((Type)Types.INTEGER).create()).parameter().id("permissionType").name("application.add-calendar-resource-group-permission.param.permission-type.name").description("application.add-calendar-resource-group-permission.param.permission-type.desc").type((Type)Types.STRING).defaultValue((Object)"USER").create()).parameter().id("usernames").name("application.add-calendar-resource-group-permission.param.usernames.name").description("application.add-calendar-resource-group-permission.param.usernames.desc").type((Type)Types.STRING_ARRAY).optional().create()).parameter().id("groupNames").name("application.add-calendar-resource-group-permission.param.group-names.name").description("application.add-calendar-resource-group-permission.param.group-names.desc").type((Type)Types.STRING_ARRAY).optional().create()).parameter().id("targetVariable").name("application.add-calendar-resource-group-permission.param.target-variable.name").description("application.add-calendar-resource-group-permission.param.target-variable.desc").type((Type)Types.VARIABLE).optional().create()).parameter().id("value").name("application.add-calendar-resource-group-permission.param.value.name").description("application.add-calendar-resource-group-permission.param.value.desc").type((Type)Types.FUNCTION).optional().create()).contextVariable().id("returnValue").name("application.add-calendar-resource-group-permission.context-variable.return-value.name").description("application.add-calendar-resource-group-permission.context-variable.return-value.desc").type((Type)Types.INTEGER_ARRAY).create();
    }

    public void execute(@Param Long resourceGroupId, @Param String permissionType, @Param String[] usernames, @Param String[] groupNames, @Param Variable targetVariable, @Param FunctionCall value, ContextVariables contextVariables) {
        this.run(resourceGroupId, permissionType, usernames, groupNames, targetVariable, value, contextVariables);
    }

    public void set(@Param Long resourceGroupId, @Param String permissionType, @Param String[] usernames, @Param String[] groupNames, @Param Variable targetVariable, @Param FunctionCall value, ContextVariables contextVariables) {
        this.run(resourceGroupId, permissionType, usernames, groupNames, targetVariable, value, contextVariables);
    }

    private void run(Long resourceGroupId, String permissionType, String[] usernames, String[] groupNames, Variable targetVariable, FunctionCall value, ContextVariables contextVariables) {
        Assert.isTrue((resourceGroupId != null && resourceGroupId > 0L ? 1 : 0) != 0, (String)"Resource group ID is required and must be positive");
        Assert.hasText((String)permissionType, (String)"Permission type is required");
        boolean isUserType = "USER".equalsIgnoreCase(permissionType);
        boolean isGroupType = "GROUP".equalsIgnoreCase(permissionType);
        Assert.isTrue((isUserType || isGroupType ? 1 : 0) != 0, (String)"Permission type must be either 'USER' or 'GROUP'");
        if (isUserType) {
            Assert.notEmpty((Object[])usernames, (String)"Usernames array is required when permission type is USER");
        } else {
            Assert.notEmpty((Object[])groupNames, (String)"Group names array is required when permission type is GROUP");
        }
        ArrayList<Long> createdShareIds = new ArrayList<Long>();
        if (isUserType) {
            List<String> usernameList = this.arrayToList(usernames);
            for (String username : usernameList) {
                try {
                    log.debug("Adding permission for user '{}' to resource group with ID: {}", (Object)username, (Object)resourceGroupId);
                    long shareId = this.calendarResourceGroupFacade.createCalendarResourceGroupShareForUser(resourceGroupId.longValue(), username);
                    createdShareIds.add(shareId);
                    log.debug("Permission added successfully for user '{}' to resource group ID: {}, share ID: {}", new Object[]{username, resourceGroupId, shareId});
                }
                catch (Exception e) {
                    log.error("Error adding permission for user '{}' to resource group ID {}: {}", new Object[]{username, resourceGroupId, e.getMessage(), e});
                    createdShareIds.add(0L);
                }
            }
        } else {
            List<String> groupNameList = this.arrayToList(groupNames);
            for (String groupName : groupNameList) {
                try {
                    log.debug("Adding permission for group '{}' to resource group with ID: {}", (Object)groupName, (Object)resourceGroupId);
                    long shareId = this.calendarResourceGroupFacade.createCalendarResourceShareGroupForGroup(resourceGroupId.longValue(), groupName);
                    createdShareIds.add(shareId);
                    log.debug("Permission added successfully for group '{}' to resource group ID: {}, share ID: {}", new Object[]{groupName, resourceGroupId, shareId});
                }
                catch (Exception e) {
                    log.error("Error adding permission for group '{}' to resource group ID {}: {}", new Object[]{groupName, resourceGroupId, e.getMessage(), e});
                    createdShareIds.add(0L);
                }
            }
        }
        if (contextVariables != null) {
            Long[] idsArray = createdShareIds.toArray(new Long[0]);
            contextVariables.set("returnValue", (Object)idsArray);
        }
        if (targetVariable != null && value != null) {
            targetVariable.setValue(value.call());
        }
    }

    private List<String> arrayToList(String[] array) {
        if (array == null) {
            return new ArrayList<String>();
        }
        return Arrays.stream(array).filter(StringUtils::isNotBlank).distinct().collect(Collectors.toList());
    }
}

