PWE.integrationComponent.registerApplication('create-user', {
    apiVersion: 2,
    buildForm: function(form) {
        buildForm(form);
    },
    validateForm: function(form) {
        return validateForm(form);
    }
});

PWE.integrationComponent.registerVariablesSetter('create-user', {
    apiVersion: 2,
    buildForm: function (form) {
        buildForm(form);
    },
    validateForm: function (form) {
        return validateForm(form);
    }
});

function buildForm(form) {
    addUserParametersFieldSet(form);
    form.addField({
        id: "existingUserModification",
        listeners: {
            change: function (value) {
                if (value === true) {
                    toggleFieldsWhenExistingUserModificationIsTrue(form);
                }  else if (form.hasFunctionValue("existingUserModification") || form.hasVariableValue("existingUserModification")) {
                    toggleFieldsWhenExistingUserModificationIsVariableOrFunction(form);
                } else {
                    toggleFieldsWhenExistingUserModificationIsFalseOrUndefined(form);
                }
            }
        }
    });
    addUserParametersSavingSettingsManagementFieldSet(form);
    afterFormLoad(form);
}

function addUserParametersFieldSet(form) {
    let userParametersFieldSet = form.addFieldSet({
        id: "user-parameters-field-set",
        collapsible: true,
        collapsed: false,
        title: PLUGIN_ADMINISTRATION_TOOLS.t("plusadministrationtools.application.create-user.user-parameters")
    });

    const fields = ['login', 'firstname', 'lastname', 'number', 'password', 'email', 'groups', 'positionSymbols'];
    fields.forEach(field => userParametersFieldSet.addField(field));

    userParametersFieldSet.addField({
        id: 'sendActivationLinkToUser',
        listeners: {
            change: function (value) {
                if (value === true) {
                    userParametersFieldSet.disable('password');
                    userParametersFieldSet.setValue('password', '');
                } else {
                    userParametersFieldSet.enable('password');
                }
            }
        }
    });

    userParametersFieldSet.addCombobox({
        id: "language",
        remote: {
            url: "plugin/com.suncode.plugin-plus-administration-tools/system/languages",
            fields: [{
                name: "name",
                type: "string"
            }],
            remoteSort: true
        },
        valueField: "name",
        displayField: "name"
    });

    userParametersFieldSet.addField('ssoLoginOnly');
    userParametersFieldSet.addField('isAnonymousUser');

    if (userParametersFieldSet.getValue('sendActivationLinkToUser') === true) {
        userParametersFieldSet.disable('password')
    } else {
        userParametersFieldSet.enable('password');
    }
}

function addUserParametersSavingSettingsManagementFieldSet(form) {
    let userParametersSavingSettingsManagementFieldSet = form.addFieldSet({
        id: "user-parameters-saving-settings-management-field-set",
        collapsible: true,
        collapsed: false,
        title: PLUGIN_ADMINISTRATION_TOOLS.t("plusadministrationtools.application.create-user.user-parameters-saving-settings-management")
    });

    PLUGIN_ADMINISTRATION_TOOLS.addOverwriteIgnoreOperationsCombobox("firstNameSavingSettings", userParametersSavingSettingsManagementFieldSet);
    PLUGIN_ADMINISTRATION_TOOLS.addOverwriteIgnoreOperationsCombobox("lastNameSavingSettings", userParametersSavingSettingsManagementFieldSet);
    PLUGIN_ADMINISTRATION_TOOLS.addOverwriteIgnoreOperationsCombobox("numberSavingSettings", userParametersSavingSettingsManagementFieldSet);
    PLUGIN_ADMINISTRATION_TOOLS.addOverwriteIgnoreOperationsCombobox("passwordSavingSettings", userParametersSavingSettingsManagementFieldSet);
    PLUGIN_ADMINISTRATION_TOOLS.addOverwriteIgnoreOperationsCombobox("emailSavingSettings", userParametersSavingSettingsManagementFieldSet);
    PLUGIN_ADMINISTRATION_TOOLS.addOverwriteAppendIgnoreOperationsCombobox("groupNamesSavingSettings", userParametersSavingSettingsManagementFieldSet);
    PLUGIN_ADMINISTRATION_TOOLS.addOverwriteAppendIgnoreOperationsCombobox("positionSymbolsSavingSettings", userParametersSavingSettingsManagementFieldSet);
    PLUGIN_ADMINISTRATION_TOOLS.addOverwriteIgnoreOperationsCombobox("languageSavingSettings", userParametersSavingSettingsManagementFieldSet);
    PLUGIN_ADMINISTRATION_TOOLS.addOverwriteIgnoreOperationsCombobox("ssoLoginOnlySavingSettings", userParametersSavingSettingsManagementFieldSet);
    PLUGIN_ADMINISTRATION_TOOLS.addOverwriteIgnoreOperationsCombobox("isAnonymousUserSavingSettings", userParametersSavingSettingsManagementFieldSet);
}

function validateForm(api) {

    if (api.getValue('sendActivationLinkToUser') !== false && api.getValue('email') === '') {
        api.markError('email');
        return false;
    }
    if (api.getValue('sendActivationLinkToUser') !== true && api.getValue('password') === '') {
        api.markError('password');
        return false;
    }
    if (!checkIfArrayContainsAnyContent(api.getValue('groups'))) {
        api.markError('groups');
        return false;
    }
    return true;
}

function checkIfArrayContainsAnyContent(arr) {
    for (let i = 0; i < arr.length; i++) {
        if (arr[i].trim() !== "") return true;
    }
    return false;
}

function afterFormLoad(form) {
    if (form.getValue("existingUserModification") === true) {
        toggleFieldsWhenExistingUserModificationIsTrue(form);
    } else if (form.hasVariableValue("existingUserModification") || form.hasFunctionValue("existingUserModification")) {
        toggleFieldsWhenExistingUserModificationIsVariableOrFunction(form);
    } else {
        toggleFieldsWhenExistingUserModificationIsFalseOrUndefined(form);
    }
}

function toggleFieldsWhenExistingUserModificationIsTrue(form) {
    form.setNotEmpty("firstNameSavingSettings", true);
    form.setNotEmpty("lastNameSavingSettings", true);
    form.setNotEmpty("numberSavingSettings", true);
    form.setNotEmpty("passwordSavingSettings", true);
    form.setNotEmpty("emailSavingSettings", true);
    form.setNotEmpty("groupNamesSavingSettings", true);
    form.setNotEmpty("positionSymbolsSavingSettings", true);
    form.setNotEmpty("languageSavingSettings", true);
    form.setNotEmpty("ssoLoginOnlySavingSettings", true);
    form.setNotEmpty("isAnonymousUserSavingSettings", true);
    form.show("user-parameters-saving-settings-management-field-set");
}

function toggleFieldsWhenExistingUserModificationIsVariableOrFunction(form) {
    form.setNotEmpty("firstNameSavingSettings", false);
    form.setNotEmpty("lastNameSavingSettings", false);
    form.setNotEmpty("numberSavingSettings", false);
    form.setNotEmpty("passwordSavingSettings", false);
    form.setNotEmpty("emailSavingSettings", false);
    form.setNotEmpty("groupNamesSavingSettings", false);
    form.setNotEmpty("positionSymbolsSavingSettings", false);
    form.setNotEmpty("languageSavingSettings", false);
    form.setNotEmpty("ssoLoginOnlySavingSettings", false);
    form.setNotEmpty("isAnonymousUserSavingSettings", false);
    form.show("user-parameters-saving-settings-management-field-set");
}

function toggleFieldsWhenExistingUserModificationIsFalseOrUndefined(form) {
    form.setNotEmpty("firstNameSavingSettings", false);
    form.setNotEmpty("lastNameSavingSettings", false);
    form.setNotEmpty("numberSavingSettings", false);
    form.setNotEmpty("passwordSavingSettings", false);
    form.setNotEmpty("emailSavingSettings", false);
    form.setNotEmpty("groupNamesSavingSettings", false);
    form.setNotEmpty("positionSymbolsSavingSettings", false);
    form.setNotEmpty("languageSavingSettings", false);
    form.setNotEmpty("ssoLoginOnlySavingSettings", false);
    form.setNotEmpty("isAnonymousUserSavingSettings", false);
    form.hide("user-parameters-saving-settings-management-field-set");
}
