PWE.integrationComponent.registerApplication('create-position', {
    apiVersion: 2,
    buildForm: function (form) {
        buildForm(form);
    }
});

PWE.integrationComponent.registerVariablesSetter('create-position', {
    apiVersion: 2,
    buildForm: function (form) {
        buildForm(form);
    }
});

function buildForm(form) {
    addPositionParametersFieldSet(form);
    form.addField({
        id: "existingPositionModification",
        listeners: {
            change: function (value) {
                if (value === true) {
                    toggleFieldsWhenExistingPositionModificationIsTrue(form);
                } else if (form.hasFunctionValue("existingPositionModification") || form.hasVariableValue("existingPositionModification")) {
                    toggleFieldsWhenExistingPositionModificationIsVariableOrFunction(form);
                } else {
                    toggleFieldsWhenExistingPositionModificationIsFalseOrUndefined(form);
                }
            }
        }
    });
    addPositionParametersSavingSettingsManagementFieldSet(form);
    afterFormLoad(form);
}

function addPositionParametersFieldSet(form) {
    let positionParametersFieldSet = form.addFieldSet({
        id: "position-parameters-field-set",
        collapsible: true,
        collapsed: false,
        title: PLUGIN_ADMINISTRATION_TOOLS.t("plusadministrationtools.application.create-position.position-parameters")
    });

    const fields = ['name', 'symbol', 'overridingPositionSymbol', 'unitSymbol', 'roleSymbols'];
    fields.forEach(field => positionParametersFieldSet.addField(field));
}

function addPositionParametersSavingSettingsManagementFieldSet(form) {
    let positionParametersSavingSettingsManagementFieldSet = form.addFieldSet({
        id: "position-parameters-saving-settings-management-field-set",
        collapsible: true,
        collapsed: false,
        title: PLUGIN_ADMINISTRATION_TOOLS.t("plusadministrationtools.application.create-position.position-parameters-saving-settings-management")
    });

    PLUGIN_ADMINISTRATION_TOOLS.addOverwriteIgnoreOperationsCombobox("overridingPositionSymbolSavingSettings", positionParametersSavingSettingsManagementFieldSet);
    PLUGIN_ADMINISTRATION_TOOLS.addOverwriteIgnoreOperationsCombobox("unitSymbolSavingSettings", positionParametersSavingSettingsManagementFieldSet);
    PLUGIN_ADMINISTRATION_TOOLS.addOverwriteAppendIgnoreOperationsCombobox("roleSymbolsSavingSettings", positionParametersSavingSettingsManagementFieldSet);
}

function afterFormLoad(form) {
    if (form.getValue("existingPositionModification") === true) {
        toggleFieldsWhenExistingPositionModificationIsTrue(form);
    } else if (form.hasVariableValue("existingPositionModification") || form.hasFunctionValue("existingPositionModification")) {
        toggleFieldsWhenExistingPositionModificationIsVariableOrFunction(form);
    } else {
        toggleFieldsWhenExistingPositionModificationIsFalseOrUndefined(form);
    }
}

function toggleFieldsWhenExistingPositionModificationIsTrue(form) {
    form.setNotEmpty("overridingPositionSymbolSavingSettings", true);
    form.setNotEmpty("unitSymbolSavingSettings", true);
    form.setNotEmpty("roleSymbolsSavingSettings", true);
    form.show("position-parameters-saving-settings-management-field-set");
}

function toggleFieldsWhenExistingPositionModificationIsVariableOrFunction(form) {
    form.setNotEmpty("overridingPositionSymbolSavingSettings", false);
    form.setNotEmpty("unitSymbolSavingSettings", false);
    form.setNotEmpty("roleSymbolsSavingSettings", false);
    form.show("position-parameters-saving-settings-management-field-set");
}

function toggleFieldsWhenExistingPositionModificationIsFalseOrUndefined(form) {
    form.setNotEmpty("overridingPositionSymbolSavingSettings", false);
    form.setNotEmpty("unitSymbolSavingSettings", false);
    form.setNotEmpty("roleSymbolsSavingSettings", false);
    form.hide("position-parameters-saving-settings-management-field-set");
}
