PWE.integrationComponent.registerApplication('plusadministrationtools.autotask.createNewPcmConfiguration', {
    apiVersion: 2,
    buildForm: function (form) {
        buildForm(form);
    }
});

function buildForm(form) {
    jQuery.ajax({
        url: PW.getAbsolutePath('plugin/com.suncode.plugin-plugin-configuration-manager/configuration/all'),
        contentType: "application/json",
        async: false,
        method: 'GET',
        success: function (response) {
            let data = [];
            for (let i = 0; i < response.size(); i++) {
                data[i] = {id: response[i].pluginInfo.id, display: response[i].pluginInfo.name, description: response[i].pluginInfo.name};
            }
            form.addCombobox({
                id: "pluginId",
                values: data,
                displayField: "display",
                valueField: "id"
            });
        }
    });
    form.addField({
        id: "newConfigurationId"
    });
    form.addCombobox({
        id: "configurationType",
        values: [
            {
                id: "xml",
                display: PLUGIN_ADMINISTRATION_TOOLS.t('plusadministrationtools.autotask.createNewPcmConfiguration.xml.name'),
                description: PLUGIN_ADMINISTRATION_TOOLS.t('plusadministrationtools.autotask.createNewPcmConfiguration.xml.name')
            },
            {
                id: "json",
                display: PLUGIN_ADMINISTRATION_TOOLS.t('plusadministrationtools.autotask.createNewPcmConfiguration.json.name'),
                description: PLUGIN_ADMINISTRATION_TOOLS.t('plusadministrationtools.autotask.createNewPcmConfiguration.json.name')
            },
            {
                id: "other",
                display: PLUGIN_ADMINISTRATION_TOOLS.t('plusadministrationtools.autotask.createNewPcmConfiguration.other.name'),
                description: PLUGIN_ADMINISTRATION_TOOLS.t('plusadministrationtools.autotask.createNewPcmConfiguration.other.name')
            }],
        displayField: "display",
        valueField: "id"
    });
    form.addField({
        id: "configuration"
    });
}