/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.administrationtools.autotask;

import com.suncode.plugin.administrationtools.Categories;
import com.suncode.plugin.administrationtools.service.UserManagementService;
import com.suncode.plugin.administrationtools.support.SharkUtils;
import com.suncode.pwfl.administration.user.exception.GroupNotFoundException;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.DivanteIcon;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.variablesetter.annotation.VariableSetter;
import com.suncode.pwfl.workflow.invocable.CommonDefinitionBuilder;
import com.suncode.pwfl.workflow.variable.Variable;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Application
@VariableSetter
public class RemoveGroup {
    private static final Logger log = LoggerFactory.getLogger(RemoveGroup.class);
    @Autowired
    private UserManagementService userManagementService;

    @Define
    public void definition(CommonDefinitionBuilder builder) {
        ((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)builder.id("remove-group")).name("application.remove-group.name")).description("application.remove-group.desc")).category(new Category[]{Categories.USER_MANAGEMENT})).icon((Icon)DivanteIcon.DELETE)).parameter().id("names").name("application.remove-group.param.names.name").type((Type)Types.STRING_ARRAY).create()).parameter().id("statusVariable").optional().name("application.remove-group.param.statusVariable.name").description("application.remove-group.param.statusVariable.desc").type((Type)Types.VARIABLE).create();
    }

    public void execute(@Param String[] names, @Param Variable statusVariable) {
        this.run(names, statusVariable);
    }

    public void set(@Param String[] names, @Param Variable statusVariable) {
        this.run(names, statusVariable);
    }

    private void run(String[] names, Variable statusVariable) {
        ArrayList<String> errors = new ArrayList<String>();
        for (String name : names) {
            try {
                SharkUtils.runInNewTransaction(() -> {
                    try {
                        this.userManagementService.removeGroup(name);
                    }
                    catch (GroupNotFoundException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
            catch (Exception e) {
                log.warn("Error removing group {}: {}", (Object)name, (Object)e.getMessage());
                errors.add(e.getMessage());
            }
        }
        if (statusVariable != null) {
            String status = errors.isEmpty() ? "OK" : String.join((CharSequence)", ", errors);
            statusVariable.setValue((Object)status);
        }
    }
}

