/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.administrationtools.autotask;

import com.suncode.plugin.administrationtools.Categories;
import com.suncode.plugin.administrationtools.autotask.parameters.CreateUserParameters;
import com.suncode.plugin.administrationtools.exception.AdministrationToolsException;
import com.suncode.plugin.administrationtools.service.UserManagementService;
import com.suncode.plugin.administrationtools.support.SharkUtils;
import com.suncode.pwfl.administration.structure.Position;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserGroup;
import com.suncode.pwfl.administration.user.exception.GroupNotFoundException;
import com.suncode.pwfl.administration.user.exception.UserAlreadyExistException;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.Parameters;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.variablesetter.annotation.VariableSetter;
import com.suncode.pwfl.workflow.invocable.CommonDefinitionBuilder;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

@Application
@VariableSetter
@ComponentsFormScript(value="scripts/dynamic-form-pwe/create-user-form.js")
public class CreateUser {
    private static final Logger log = LoggerFactory.getLogger(CreateUser.class);
    @Autowired
    private UserManagementService userManagementService;

    @Define
    public void definition(CommonDefinitionBuilder builder) {
        ((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)builder.id("create-user")).name("application.create-user.name")).description("application.create-user.desc")).category(new Category[]{Categories.USER_MANAGEMENT})).icon((Icon)SilkIconPack.NEW)).parameter().id("login").name("application.create-user.param.login.name").type((Type)Types.STRING).create()).parameter().id("firstname").optional().name("application.create-user.param.firstname.name").type((Type)Types.STRING).create()).parameter().id("lastname").optional().name("application.create-user.param.lastname.name").type((Type)Types.STRING).create()).parameter().id("number").optional().name("application.create-user.param.number.name").type((Type)Types.STRING).create()).parameter().id("password").optional().name("application.create-user.param.password.name").type((Type)Types.STRING).create()).parameter().id("email").optional().name("application.create-user.param.email.name").type((Type)Types.STRING).create()).parameter().id("groups").name("application.create-user.param.groups.name").type((Type)Types.STRING_ARRAY).create()).parameter().id("positionSymbols").name("application.create-user.param.positions-symbol.name").type((Type)Types.STRING_ARRAY).create()).parameter().id("sendActivationLinkToUser").name("application.create-user.param.send-activation-link-to-user.name").description("application.create-user.param.send-activation-link-to-user.desc").defaultValue((Object)false).type((Type)Types.BOOLEAN).create()).parameter().id("language").name("application.create-user.param.language.name").description("application.create-user.param.language.desc").type((Type)Types.STRING).optional().create()).parameter().id("ssoLoginOnly").name("application.create-user.param.sso-login-only.name").description("application.create-user.param.sso-login-only.desc").type((Type)Types.BOOLEAN).optional().defaultValue((Object)false).create()).parameter().id("isAnonymousUser").name("application.create-user.param.is-anonymous-user.name").description("application.create-user.param.is-anonymous-user.desc").type((Type)Types.BOOLEAN).optional().defaultValue((Object)false).create()).parameter().id("existingUserModification").name("application.create-user.param.existing-user-modification.name").description("application.create-user.param.existing-user-modification.desc").type((Type)Types.BOOLEAN).defaultValue((Object)false).create()).parameter().id("firstNameSavingSettings").name("application.create-user.param.first-name-saving-settings.name").type((Type)Types.STRING).optional().defaultValue((Object)"IGNORE").create()).parameter().id("lastNameSavingSettings").name("application.create-user.param.last-name-saving-settings.name").type((Type)Types.STRING).optional().defaultValue((Object)"IGNORE").create()).parameter().id("numberSavingSettings").name("application.create-user.param.number-saving-settings.name").type((Type)Types.STRING).optional().defaultValue((Object)"IGNORE").create()).parameter().id("passwordSavingSettings").name("application.create-user.param.password-saving-settings.name").type((Type)Types.STRING).optional().defaultValue((Object)"IGNORE").create()).parameter().id("emailSavingSettings").name("application.create-user.param.email-saving-settings.name").type((Type)Types.STRING).optional().defaultValue((Object)"IGNORE").create()).parameter().id("groupNamesSavingSettings").name("application.create-user.param.group-names-saving-settings.name").type((Type)Types.STRING).optional().defaultValue((Object)"IGNORE").create()).parameter().id("positionSymbolsSavingSettings").name("application.create-user.param.position-symbols-saving-settings.name").type((Type)Types.STRING).optional().defaultValue((Object)"IGNORE").create()).parameter().id("languageSavingSettings").name("application.create-user.param.language-saving-settings.name").type((Type)Types.STRING).optional().defaultValue((Object)"IGNORE").create()).parameter().id("ssoLoginOnlySavingSettings").name("application.create-user.param.sso-login-only-saving-settings.name").type((Type)Types.STRING).optional().defaultValue((Object)"IGNORE").create()).parameter().id("isAnonymousUserSavingSettings").name("application.create-user.param.is-anonymous-user-saving-settings.name").type((Type)Types.STRING).optional().defaultValue((Object)"IGNORE").create();
    }

    public void execute(Parameters parameters) throws UserAlreadyExistException, GroupNotFoundException, AdministrationToolsException {
        this.run(parameters);
    }

    public void set(Parameters parameters) throws UserAlreadyExistException, GroupNotFoundException, AdministrationToolsException {
        this.run(parameters);
    }

    private void run(Parameters parameters) throws UserAlreadyExistException, GroupNotFoundException, AdministrationToolsException {
        CreateUserParameters createUserParameters = new CreateUserParameters(parameters);
        Assert.isTrue((!StringUtils.isBlank((CharSequence)createUserParameters.getLogin()) ? 1 : 0) != 0, (String)"Login parameter is empty");
        Assert.isTrue((!StringUtils.isBlank((CharSequence)createUserParameters.getEmail()) || createUserParameters.getSendActivationLinkToUser() == false ? 1 : 0) != 0, (String)"The e-mail address must be completed if an activation e-mail is to be sent.");
        if (createUserParameters.getExistingUserModification().booleanValue()) {
            User user = this.userManagementService.findUserByLogin(createUserParameters.getLogin());
            this.modifyUserProperties(user, createUserParameters);
            this.userManagementService.updateUser(user);
        } else {
            List<String> groupList = Arrays.stream(createUserParameters.getGroups()).filter(StringUtils::isNotBlank).map(String::trim).collect(Collectors.toList());
            Assert.isTrue((!groupList.isEmpty() ? 1 : 0) != 0, (String)"Group list is empty. At least one group must be added.");
            this.createGroupsIfNotExist(groupList);
            User user = this.createUserDto(createUserParameters.getLogin(), createUserParameters.getFirstname(), createUserParameters.getLastname(), createUserParameters.getNumber(), createUserParameters.getPassword(), createUserParameters.getEmail(), createUserParameters.getSendActivationLinkToUser(), createUserParameters.getLanguage(), createUserParameters.getSsoLoginOnly(), createUserParameters.getIsAnonymousUser());
            this.userManagementService.createUser(user, groupList, Arrays.asList(createUserParameters.getPositionSymbols()));
        }
        log.debug(String.join((CharSequence)" ", "User has been added/updated. Login:", createUserParameters.getLogin(), ", firstname:", createUserParameters.getFirstname(), ", lastname:", createUserParameters.getLastname(), ", email:", createUserParameters.getEmail(), ", groupNames:", String.join((CharSequence)", ", createUserParameters.getGroups()), ", send activation link to user:", createUserParameters.getSendActivationLinkToUser() != false ? "Yes" : "No", ", position symbols:", String.join((CharSequence)", ", createUserParameters.getPositionSymbols())));
    }

    private void createGroupsIfNotExist(List<String> groupList) {
        SharkUtils.runInNewTransaction(() -> groupList.stream().forEach(groupName -> this.userManagementService.createGroupIfNotExist((String)groupName, (String)groupName)));
    }

    private User createUserDto(String loginWithDomain, String firstname, String lastname, String number, String password, String email, Boolean sendActivationLinkToUser, String language, Boolean onlySsoLogin, Boolean anonymous) {
        User user = new User(loginWithDomain, sendActivationLinkToUser != false ? "" : password);
        user.setEmail(email);
        user.setFirstName(firstname);
        user.setLastName(lastname);
        user.setNumber(number);
        user.setWaitingForPasswordAssign(sendActivationLinkToUser.booleanValue());
        user.setLanguage(language);
        user.setOnlySsoLogin(onlySsoLogin.booleanValue());
        user.setAnonymous(anonymous.booleanValue());
        return user;
    }

    private void modifyUserProperties(User user, CreateUserParameters parameters) throws AdministrationToolsException, GroupNotFoundException {
        if (parameters.getFirstNameSavingSettings().equals("OVERWRITE")) {
            user.setFirstName(parameters.getFirstname());
        }
        if (parameters.getLastNameSavingSettings().equals("OVERWRITE")) {
            user.setLastName(parameters.getLastname());
        }
        if (parameters.getNumberSavingSettings().equals("OVERWRITE")) {
            user.setNumber(parameters.getNumber());
        }
        if (parameters.getPasswordSavingSettings().equals("OVERWRITE")) {
            user.setPassword(parameters.getPassword());
        }
        if (parameters.getEmailSavingSettings().equals("OVERWRITE")) {
            user.setEmail(parameters.getEmail());
        }
        this.updateUserGroups(user, parameters.getGroupNamesSavingSettings(), parameters.getGroups());
        this.updateUserPositions(user, parameters.getPositionSymbolsSavingSettings(), parameters.getPositionSymbols());
        if (parameters.getLanguageSavingSettings().equals("OVERWRITE")) {
            user.setLanguage(parameters.getLanguage());
        }
        if (parameters.getSsoLoginOnlySavingSettings().equals("OVERWRITE")) {
            user.setOnlySsoLogin(parameters.getSsoLoginOnly().booleanValue());
        }
        if (parameters.getIsAnonymousUserSavingSettings().equals("OVERWRITE")) {
            user.setAnonymous(parameters.getIsAnonymousUser().booleanValue());
        }
    }

    private void updateUserGroups(User user, String groupNamesSavingSettings, String[] groupNames) throws GroupNotFoundException, AdministrationToolsException {
        List<String> groupList = Arrays.stream(groupNames).filter(StringUtils::isNotBlank).map(String::trim).collect(Collectors.toList());
        if (groupNamesSavingSettings.equals("OVERWRITE") || groupNamesSavingSettings.equals("APPEND")) {
            Assert.isTrue((!groupList.isEmpty() ? 1 : 0) != 0, (String)"Group list is empty. At least one group must be added.");
            this.createGroupsIfNotExist(groupList);
        }
        switch (groupNamesSavingSettings) {
            case "OVERWRITE": {
                this.userManagementService.addUserToGroupsInNewTransaction(user.getUserName(), groupList);
                List<String> groupsToRemove = user.getGroups().stream().map(UserGroup::getName).filter(name -> groupList.stream().noneMatch(groupName -> groupName.equals(name))).collect(Collectors.toList());
                this.userManagementService.removeUserFromGroups(user.getUserName(), groupsToRemove);
                break;
            }
            case "APPEND": {
                this.userManagementService.addUserToGroups(user.getUserName(), groupList);
                break;
            }
        }
    }

    private void updateUserPositions(User user, String positionSymbolsSavingSettings, String[] positionSymbols) {
        switch (positionSymbolsSavingSettings) {
            case "OVERWRITE": {
                user.setPositions(this.userManagementService.getPositions(positionSymbols));
                break;
            }
            case "APPEND": {
                HashSet<Position> totalPositions = new HashSet<Position>(user.getPositions());
                totalPositions.addAll(this.userManagementService.getPositions(positionSymbols));
                user.setPositions(totalPositions);
                break;
            }
        }
    }
}

