/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.administrationtools.autotask;

import com.suncode.plugin.administrationtools.Categories;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.content.validator.model.ValidationError;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.model.FileType;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.service.ConfigurationFileService;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.translation.Translator;
import com.suncode.pwfl.web.ui.DivanteIcon;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.exception.AcceptanceException;
import com.suncode.pwfl.workflow.invocable.CommonDefinitionBuilder;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.StringJoiner;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

@Application
@ComponentsFormScript(value="scripts/dynamic-form-pwe/create-new-pcm-configuration.js")
public class CreateNewPcmConfiguration {
    private static final Logger log = LoggerFactory.getLogger(CreateNewPcmConfiguration.class);
    private static final String ID = "plusadministrationtools.autotask.createNewPcmConfiguration";
    @Autowired
    private ConfigurationFileService configurationFileService;

    @Define
    public void definition(CommonDefinitionBuilder builder) {
        ((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)builder.id(ID)).name(ID.concat(".name"))).description(ID.concat(".desc"))).category(new Category[]{Categories.USER_MANAGEMENT})).icon((Icon)DivanteIcon.UPLOAD)).parameter().id("pluginId").name(ID.concat(".param.pluginId.name")).type((Type)Types.STRING).create()).parameter().id("newConfigurationId").name(ID.concat(".param.newConfigurationId.name")).type((Type)Types.STRING).create()).parameter().id("configurationType").name(ID.concat(".param.configurationType.name")).type((Type)Types.STRING).create()).parameter().id("configuration").name(ID.concat(".param.configuration.name")).type((Type)Types.STRING).create();
    }

    public void execute(@Param String pluginId, @Param String newConfigurationId, @Param String configurationType, @Param String configuration, Translator translator) throws AcceptanceException {
        try {
            this.checkAsserts(pluginId, newConfigurationId, configurationType, translator);
            FileType filetype = FileType.fromExtension((String)configurationType);
            this.checkError(configuration, filetype);
            this.configurationFileService.createFile(pluginId, newConfigurationId, filetype);
            this.configurationFileService.saveFile(pluginId, newConfigurationId, (InputStream)new ByteArrayInputStream(configuration.getBytes(StandardCharsets.UTF_8)));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new AcceptanceException(e.getMessage());
        }
    }

    private void checkError(String configuration, FileType filetype) throws AcceptanceException {
        if (filetype.getValidator() == null) {
            return;
        }
        List listOfErrors = filetype.getValidator().validate(configuration);
        if (!listOfErrors.isEmpty()) {
            log.error(((ValidationError)listOfErrors.get(0)).getLocalizedMessage(), ((ValidationError)listOfErrors.get(0)).getEx());
            throw new AcceptanceException(((ValidationError)listOfErrors.get(0)).getLocalizedMessage());
        }
    }

    private void checkAsserts(String pluginId, String newConfigurationId, String configurationType, Translator translator) throws AcceptanceException {
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)pluginId), (String)translator.getMessage(ID.concat(".configuration.emptyPluginId")));
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)newConfigurationId), (String)translator.getMessage(ID.concat(".configuration.emptyNewConfigurationId")));
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)configurationType), (String)translator.getMessage(ID.concat(".configuration.emptyConfigurationType")));
        if (this.configurationFileService.doesFileExist(pluginId, newConfigurationId)) {
            StringJoiner stringJoiner = new StringJoiner(" ");
            stringJoiner.add(translator.getMessage(ID.concat(".configuration.exists")));
            stringJoiner.add(newConfigurationId);
            stringJoiner.add(translator.getMessage(ID.concat(".configuration.for.plugin")));
            stringJoiner.add(pluginId);
            log.error(stringJoiner.toString());
            throw new AcceptanceException(stringJoiner.toString());
        }
    }
}

