/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.framework.web;

import com.suncode.plugin.framework.Plugin;
import com.suncode.plugin.framework.PluginsException;
import com.suncode.plugin.framework.config.ModuleDefinition;
import com.suncode.plugin.framework.defaultView.DefaultView;
import com.suncode.plugin.framework.defaultView.DefaultViewProvider;
import com.suncode.plugin.framework.defaultView.DefaultViewProviderRegistry;
import com.suncode.plugin.framework.support.LocalizedMessage;
import com.suncode.plugin.framework.support.module.ModuleHelper;
import com.suncode.plugin.framework.support.module.ModuleSupport;
import com.suncode.plugin.framework.web.support.ScopedWebLink;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

public class DefaultViewModule
extends ModuleSupport<DefaultView> {
    public static final String MODULE_TYPE = "default-view";
    private static final int PLUGIN_DEFAULT_VIEW_ORDER = 100;
    @Autowired
    private DefaultViewProviderRegistry providerRegistry;
    private LocalizedMessage label;
    private ScopedWebLink url;
    private String providerClass;
    private DefaultViewProvider defaultViewProvider;

    protected void initModule() throws PluginsException {
        if (this.isStandardDefaultViewDefinition()) {
            this.label = ModuleHelper.getLocalizedMessage((String)"label", (Plugin)this.getPlugin(), (ModuleDefinition)this.getDefinition());
            this.url = ScopedWebLink.parse((ModuleDefinition)this.getDefinition(), (Plugin)this.getPlugin());
            Assert.notNull((Object)this.url, (String)"Link element is required");
        } else {
            this.providerClass = this.getDefinition().getElement().getAttribute("provider");
        }
    }

    private boolean isStandardDefaultViewDefinition() {
        return this.getDefinition().getElement().hasAttribute("label");
    }

    public DefaultView getObject() {
        if (this.label == null && this.url == null) {
            return null;
        }
        return new DefaultView(this.getPlugin().getKey() + "_defaultView", this.label.getMessage(), this.url.getPath(), 100);
    }

    public void enable() throws PluginsException {
        if (this.providerClass != null) {
            this.registerDefaultViewProvider();
        }
    }

    private void registerDefaultViewProvider() {
        try {
            Class<?> clazz = this.getPlugin().getClassLoader().loadClass(this.providerClass);
            this.defaultViewProvider = (DefaultViewProvider)this.getPlugin().getContext().getAutowireCapableBeanFactory().createBean(clazz);
            this.providerRegistry.registerProvider(this.getPlugin().getKey(), this.defaultViewProvider);
        }
        catch (ClassNotFoundException e) {
            throw new PluginsException("DefaultViewProvider class [" + this.providerClass + "] not found");
        }
    }

    public void disable() throws PluginsException {
        if (this.defaultViewProvider != null) {
            this.providerRegistry.unregisterProvider(this.getPlugin().getKey());
        }
    }

    public DefaultViewProvider getDefaultViewProvider() {
        return this.defaultViewProvider;
    }
}

