/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.framework.web.mvc.support;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.cfg.CoercionAction;
import com.fasterxml.jackson.databind.cfg.CoercionInputShape;
import com.fasterxml.jackson.databind.type.LogicalType;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.suncode.plugin.framework.Plugin;
import com.suncode.plugin.framework.context.RootContextAware;
import com.suncode.plugin.framework.util.SqlDateModule;
import com.suncode.plugin.framework.web.mvc.MvcModuleConfigurer;
import com.suncode.plugin.framework.web.mvc.support.CompositeMvcModuleConfigurer;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.format.support.FormattingConversionService;
import org.springframework.http.MediaType;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;
import org.springframework.validation.Validator;
import org.springframework.web.accept.ContentNegotiationManager;
import org.springframework.web.multipart.MultipartResolver;
import org.springframework.web.multipart.support.StandardServletMultipartResolver;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.config.annotation.PathMatchConfigurer;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistration;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurationSupport;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public abstract class PluginMvcConfigurationSupport
extends WebMvcConfigurationSupport
implements RootContextAware {
    @Autowired
    private Plugin plugin;
    private ApplicationContext rootContext;
    private CompositeMvcModuleConfigurer configurers = new CompositeMvcModuleConfigurer();

    public Plugin getPlugin() {
        return this.plugin;
    }

    public void setRootContext(ApplicationContext rootContext) {
        this.rootContext = rootContext;
    }

    public ApplicationContext getRootContext() {
        return this.rootContext;
    }

    @Autowired(required=false)
    public void configurers(List<MvcModuleConfigurer> configurers) {
        if (configurers == null || configurers.isEmpty()) {
            return;
        }
        this.configurers.addMvcModuleConfigurers(configurers);
    }

    public CompositeMvcModuleConfigurer getConfigurers() {
        return this.configurers;
    }

    @Bean
    public MultipartResolver multipartResolver() {
        return new StandardServletMultipartResolver();
    }

    @Bean
    public LocaleResolver localeResolver() {
        final LocaleResolver system = (LocaleResolver)this.rootContext.getBean("localeResolver", LocaleResolver.class);
        return new LocaleResolver(){

            public Locale resolveLocale(HttpServletRequest request) {
                return system.resolveLocale(request);
            }

            public void setLocale(HttpServletRequest request, HttpServletResponse response, Locale locale) {
                system.setLocale(request, response, locale);
            }
        };
    }

    protected RequestMappingHandlerMapping createRequestMappingHandlerMapping() {
        RequestMappingHandlerMapping handlerMapping = new RequestMappingHandlerMapping();
        handlerMapping.setPathPrefixes(Map.of("/" + this.plugin.getKey(), clazz -> true));
        return handlerMapping;
    }

    protected void configurePathMatch(PathMatchConfigurer configurer) {
        configurer.setPathMatcher((PathMatcher)new AntPathMatcher());
        configurer.setUseTrailingSlashMatch(Boolean.valueOf(true));
    }

    protected void addResourceHandlers(ResourceHandlerRegistry registry) {
        String prefix = "/" + this.plugin.getKey() + "/resources/";
        ResourceHandlerRegistration dynamicResources = registry.addResourceHandler(new String[]{prefix + "**"});
        dynamicResources.addResourceLocations(new String[]{"/resources/"});
        dynamicResources.setCachePeriod(Integer.valueOf(1));
        long timestamp = this.plugin.getLastUpdateDate().getTime();
        ResourceHandlerRegistration staticResources = registry.addResourceHandler(new String[]{prefix + timestamp + "/**"});
        staticResources.addResourceLocations(new String[]{"/resources/"});
        staticResources.setCachePeriod(Integer.valueOf(2592000));
    }

    public RequestMappingHandlerAdapter requestMappingHandlerAdapter(ContentNegotiationManager contentNegotiationManager, FormattingConversionService conversionService, Validator validator) {
        RequestMappingHandlerAdapter adapter = super.requestMappingHandlerAdapter(contentNegotiationManager, conversionService, validator);
        adapter.setCacheSeconds(-1);
        MappingJackson2HttpMessageConverter jacksonConverter = adapter.getMessageConverters().stream().filter(converter -> converter instanceof MappingJackson2HttpMessageConverter).map(converter -> (MappingJackson2HttpMessageConverter)converter).findFirst().orElseThrow(() -> new IllegalStateException("Could not find jackson message converter"));
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new SqlDateModule());
        objectMapper.registerModule((Module)new JodaModule());
        objectMapper.registerModule((Module)new Jdk8Module());
        objectMapper.coercionConfigFor(LogicalType.POJO).setCoercion(CoercionInputShape.EmptyString, CoercionAction.AsEmpty);
        ArrayList<MediaType> mediaTypes = new ArrayList<MediaType>(jacksonConverter.getSupportedMediaTypes());
        mediaTypes.add(MediaType.ALL);
        jacksonConverter.setSupportedMediaTypes(mediaTypes);
        jacksonConverter.setObjectMapper(objectMapper);
        this.configurers.configureMessageConverters(adapter.getMessageConverters());
        return adapter;
    }
}

