/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.framework.web.mvc;

import com.suncode.plugin.framework.PluginContext;
import com.suncode.plugin.framework.PluginsException;
import com.suncode.plugin.framework.support.module.ModuleSupport;
import com.suncode.plugin.framework.web.mvc.FrameworkDispatcherServlet;
import com.suncode.plugin.framework.web.mvc.freemarker.FreemarkerMvcConfiguration;
import com.suncode.plugin.framework.web.mvc.support.DelegatingServletConfig;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.servlet.DispatcherServlet;

public class MvcModule
extends ModuleSupport<Void> {
    public static final String MODULE_TYPE = "web-mvc";
    @Autowired
    private FrameworkDispatcherServlet dispatcherServlet;

    protected void initModule() throws PluginsException {
        this.getPlugin().getContext().registerBeanDefinition(FreemarkerMvcConfiguration.class.getName(), (BeanDefinition)new RootBeanDefinition(FreemarkerMvcConfiguration.class));
    }

    private DispatcherServlet createDispatcherServlet(WebApplicationContext context) {
        DispatcherServlet servlet = new DispatcherServlet(context);
        servlet.setPublishContext(false);
        servlet.setPublishEvents(false);
        return servlet;
    }

    public void enable() throws PluginsException {
        PluginContext context = this.getPlugin().getContext();
        try {
            DelegatingServletConfig servletConfig = new DelegatingServletConfig(this.getPlugin().getKey(), context.getServletContext());
            DispatcherServlet servlet = this.createDispatcherServlet((WebApplicationContext)context);
            servlet.init((ServletConfig)servletConfig);
            this.dispatcherServlet.registerPluginDispatcher(this.getPlugin(), servlet);
        }
        catch (ServletException e) {
            throw new PluginsException((Throwable)e);
        }
    }

    public void disable() throws PluginsException {
        this.dispatcherServlet.unregisterPluginDispatcher(this.getPlugin());
    }
}

