/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.framework.web.mvc.freemarker;

import com.suncode.plugin.framework.Plugin;
import com.suncode.plugin.framework.web.mvc.freemarker.DecoratingFreemarkerViewResolver;
import com.suncode.plugin.framework.web.mvc.freemarker.FreeMarkerConfigurer;
import com.suncode.plugin.framework.web.mvc.support.PluginMvcConfigurationSupport;
import com.suncode.plugin.framework.web.support.decorator.ViewDecoratorResolver;
import freemarker.cache.TemplateLoader;
import freemarker.ext.jsp.TaglibFactory;
import java.util.Properties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ResourceLoader;
import org.springframework.ui.freemarker.SpringTemplateLoader;

@Configuration
public class FreemarkerMvcConfiguration
extends PluginMvcConfigurationSupport {
    @Bean
    public FreeMarkerConfigurer freemarkerConfigurer() {
        FreeMarkerConfigurer configurer = new FreeMarkerConfigurer();
        Properties settings = new Properties();
        this.configureFreemarker(settings);
        SpringTemplateLoader templateLoader = new SpringTemplateLoader((ResourceLoader)this.getPlugin().getContext(), "/");
        configurer.setPreTemplateLoaders(new TemplateLoader[]{templateLoader});
        configurer.setFreemarkerSettings(settings);
        return configurer;
    }

    protected void configureFreemarker(Properties properties) {
        properties.put("localized_lookup", "false");
        properties.put("template_exception_handler", "rethrow");
    }

    @Bean
    public DecoratingFreemarkerViewResolver decoratingFreemarkerViewResolver(Plugin plugin) {
        ApplicationContext root = this.getRootContext();
        DecoratingFreemarkerViewResolver viewResolver = new DecoratingFreemarkerViewResolver(plugin, (ViewDecoratorResolver)root.getBean("decoratorResolver", ViewDecoratorResolver.class), (TaglibFactory)root.getBean("com.suncode.plugin.framework.web.TaglibFactory", TaglibFactory.class));
        viewResolver.setPrefix("/views/");
        viewResolver.setSuffix(".ftl");
        viewResolver.setContentType("text/html;charset=UTF-8");
        return viewResolver;
    }
}

