/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.framework.web.mvc.freemarker;

import com.suncode.plugin.framework.Plugin;
import com.suncode.plugin.framework.web.mvc.support.PluginRequestContext;
import com.suncode.plugin.framework.web.support.decorator.ViewDecorator;
import com.suncode.plugin.framework.web.support.decorator.ViewDecoratorResolver;
import freemarker.ext.jsp.TaglibFactory;
import freemarker.ext.servlet.HttpRequestHashModel;
import freemarker.ext.servlet.HttpRequestParametersHashModel;
import freemarker.ext.servlet.HttpSessionHashModel;
import freemarker.ext.servlet.ServletContextHashModel;
import freemarker.template.SimpleHash;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import javax.servlet.GenericServlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.beans.BeansException;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.servlet.view.freemarker.FreeMarkerView;

public class DecoratingFreemarkerView
extends FreeMarkerView {
    private static final String VIEW_DECORATOR_ATTR = DecoratingFreemarkerView.class.getName() + ".VIEW_DECORATOR";
    private final Plugin plugin;
    private final ViewDecoratorResolver decoratorResolver;
    private final TaglibFactory taglibFactory;
    private ServletContextHashModel servletContextHashModel;

    protected void initServletContext(ServletContext servletContext) throws BeansException {
        super.initServletContext(servletContext);
        FmServlet servlet = new FmServlet();
        servlet.init(new FmServletConfig());
        this.servletContextHashModel = new ServletContextHashModel((GenericServlet)servlet, this.getObjectWrapper());
    }

    protected SimpleHash buildTemplateModel(Map<String, Object> model, HttpServletRequest request, jakarta.servlet.http.HttpServletResponse response) {
        SimpleHash fmModel = super.buildTemplateModel(model, request, response);
        fmModel.put("pluginContext", (Object)this.buildPluginContext(model, request, response));
        fmModel.put("JspTaglibs", (Object)this.taglibFactory);
        fmModel.put("Application", (Object)this.servletContextHashModel);
        fmModel.put("Session", (Object)this.buildSessionModel(request, response));
        fmModel.put("Request", (Object)new HttpRequestHashModel((javax.servlet.http.HttpServletRequest)request, (HttpServletResponse)response, this.getObjectWrapper()));
        fmModel.put("RequestParameters", (Object)new HttpRequestParametersHashModel((javax.servlet.http.HttpServletRequest)request));
        return fmModel;
    }

    private HttpSessionHashModel buildSessionModel(HttpServletRequest request, jakarta.servlet.http.HttpServletResponse response) {
        jakarta.servlet.http.HttpSession session = request.getSession(false);
        if (session != null) {
            return new HttpSessionHashModel((HttpSession)session, this.getObjectWrapper());
        }
        return new HttpSessionHashModel(null, (javax.servlet.http.HttpServletRequest)request, (HttpServletResponse)response, this.getObjectWrapper());
    }

    private PluginRequestContext buildPluginContext(Map<String, Object> model, HttpServletRequest request, jakarta.servlet.http.HttpServletResponse response) {
        return new PluginRequestContext(this.plugin, request, response, this.getServletContext(), model);
    }

    protected void doRender(Map<String, Object> model, HttpServletRequest request, jakarta.servlet.http.HttpServletResponse response) throws Exception {
        this.prepareForDecoration(request, model);
        super.doRender(model, request, response);
    }

    public void prepareForDecoration(HttpServletRequest request, Map<String, Object> model) {
        ViewDecorator decorator;
        if (this.decoratorResolver != null && (decorator = this.decoratorResolver.getDecorator(request)) != null) {
            model.put(VIEW_DECORATOR_ATTR, decorator);
        }
    }

    protected void processTemplate(Template template, SimpleHash model, jakarta.servlet.http.HttpServletResponse response) throws IOException, TemplateException {
        HttpServletRequest request = (HttpServletRequest)RequestContextHolder.getRequestAttributes().resolveReference("request");
        ViewDecorator decorator = (ViewDecorator)request.getAttribute(VIEW_DECORATOR_ATTR);
        if (decorator != null) {
            this.renderDecoratedTemplate(decorator, template, model, request, response);
        } else {
            super.processTemplate(template, model, response);
        }
    }

    protected void renderDecoratedTemplate(ViewDecorator decorator, Template template, SimpleHash model, HttpServletRequest request, jakarta.servlet.http.HttpServletResponse response) throws TemplateException, IOException {
        StringWriter writer = new StringWriter();
        template.process((Object)model, (Writer)writer);
        try {
            decorator.decorate(writer.toString(), request, response);
        }
        catch (jakarta.servlet.ServletException e) {
            throw new IOException("Dekoracja widoku nie powiod\u0142a si\u0119", e);
        }
    }

    @ConstructorProperties(value={"plugin", "decoratorResolver", "taglibFactory"})
    public DecoratingFreemarkerView(Plugin plugin, ViewDecoratorResolver decoratorResolver, TaglibFactory taglibFactory) {
        this.plugin = plugin;
        this.decoratorResolver = decoratorResolver;
        this.taglibFactory = taglibFactory;
    }

    private static class FmServlet
    extends GenericServlet {
        private FmServlet() {
        }

        public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        }
    }

    private class FmServletConfig
    implements ServletConfig {
        private FmServletConfig() {
        }

        public String getServletName() {
            return DecoratingFreemarkerView.this.getBeanName();
        }

        public javax.servlet.ServletContext getServletContext() {
            return (javax.servlet.ServletContext)DecoratingFreemarkerView.this.getServletContext();
        }

        public String getInitParameter(String paramName) {
            return null;
        }

        public Enumeration<String> getInitParameterNames() {
            return Collections.enumeration(new HashSet());
        }
    }
}

