/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.framework.web;

import com.suncode.plugin.framework.Plugin;
import com.suncode.plugin.framework.PluginsException;
import com.suncode.plugin.framework.config.ModuleDefinition;
import com.suncode.plugin.framework.support.Condition;
import com.suncode.plugin.framework.support.LocalizedMessage;
import com.suncode.plugin.framework.support.module.ModuleHelper;
import com.suncode.plugin.framework.support.module.ModuleSupport;
import com.suncode.plugin.framework.util.XmlUtils;
import com.suncode.plugin.framework.web.WebFragmentsManager;
import com.suncode.plugin.framework.web.support.MenuBuilder;
import com.suncode.plugin.framework.web.support.MenuEntry;
import com.suncode.plugin.framework.web.support.MenuItem;
import com.suncode.plugin.framework.web.support.ScopedWebLink;
import com.suncode.plugin.framework.web.support.WebLink;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.w3c.dom.Element;

public class MenuEntryModule
extends ModuleSupport<MenuBuilder> {
    public static final String MODULE_TYPE = "menu-entry";
    @Autowired
    private WebFragmentsManager webFragmentsManager;
    private String menuBuilderClass;
    private MenuBuilder menuBuilder;

    protected void initModule() throws PluginsException {
        Plugin plugin = this.getPlugin();
        ModuleDefinition definition = this.getDefinition();
        if (ModuleHelper.hasAttribute((String)"builder", (ModuleDefinition)definition)) {
            this.menuBuilderClass = ModuleHelper.getAttribute((String)"builder", (ModuleDefinition)definition);
        } else {
            this.menuBuilder = new StaticMenuBuilder(ModuleHelper.getAttribute((String)"section", (ModuleDefinition)definition), ScopedWebLink.parse((ModuleDefinition)definition, (Plugin)plugin), ModuleHelper.getLocalizedMessage((String)"label", (Plugin)plugin, (ModuleDefinition)definition), ModuleHelper.getOrder((ModuleDefinition)definition), ModuleHelper.getConditions((Plugin)plugin, (ModuleDefinition)definition), this.iconName(plugin, definition));
        }
    }

    private MenuBuilder createBuilder(String builderClass) {
        try {
            Class<?> clazz = this.getPlugin().getClassLoader().loadClass(builderClass);
            return (MenuBuilder)this.getPlugin().getContext().getAutowireCapableBeanFactory().createBean(clazz);
        }
        catch (ClassNotFoundException e) {
            throw new PluginsException("Error loading class [" + builderClass + "]", (Throwable)e);
        }
    }

    public void enable() {
        if (this.menuBuilderClass != null) {
            this.menuBuilder = this.createBuilder(this.menuBuilderClass);
        }
        this.refresh(true);
    }

    public void disable() {
        this.refresh(false);
    }

    private void refresh(boolean includePlugin) {
        this.webFragmentsManager.refreshInterface(this.getPlugin().getKey(), includePlugin);
    }

    private String iconName(Plugin plugin, ModuleDefinition definition) {
        Element element = XmlUtils.getFirstChildElement((String)"icon", (Element)definition.getElement());
        return element != null ? element.getTextContent().trim() : null;
    }

    public MenuBuilder getObject() {
        return this.menuBuilder;
    }

    private class StaticMenuBuilder
    implements MenuBuilder {
        private String section;
        private ScopedWebLink link;
        private LocalizedMessage label;
        private int order;
        private List<Condition> conditions;
        private String iconName;

        public StaticMenuBuilder(String section, ScopedWebLink link, LocalizedMessage label, int order, List<Condition> conditions, String iconName) {
            this.section = section;
            this.link = link;
            this.label = label;
            this.order = order;
            this.conditions = conditions;
            this.iconName = iconName;
        }

        public void menu(String keyPrefix, MenuBuilder.Builder builder) {
            builder.section(this.section).addItem((MenuItem)new MenuEntry(keyPrefix, (WebLink)this.link, this.label, this.order, this.conditions, this.iconName));
        }
    }
}

