/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.framework.web.mvc.support;

import com.suncode.plugin.framework.Plugin;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.support.RequestContext;

public class PluginRequestContext
extends RequestContext {
    private Plugin requestPlugin;
    private HttpServletResponse response;

    public PluginRequestContext(Plugin plugin, HttpServletRequest request, HttpServletResponse response, ServletContext servletContext, Map<String, Object> model) {
        super(request, response, servletContext, model);
        this.requestPlugin = plugin;
    }

    protected void initContext(HttpServletRequest request, HttpServletResponse response, ServletContext servletContext, Map<String, Object> model) {
        super.initContext(request, response, servletContext, model);
        this.response = response;
    }

    public String getPluginContextPath() {
        return super.getContextPath() + "/plugin" + "/" + this.requestPlugin.getKey();
    }

    public String getPluginContextUrl(String relativeUrl) {
        String url = this.getPluginContextPath() + relativeUrl;
        if (this.response != null) {
            url = this.response.encodeURL(url);
        }
        return url;
    }

    public Plugin getRequestPlugin() {
        return this.requestPlugin;
    }

    public String getPluginResourcesPath() {
        String url = this.getPluginContextPath() + "/resources/" + this.requestPlugin.getLastUpdateDate().getTime();
        if (this.response != null) {
            url = this.response.encodeURL(url);
        }
        return url;
    }

    public String getPluginResourcesUrl(String relativeUrl) {
        String url = this.getPluginResourcesPath() + relativeUrl;
        if (this.response != null) {
            url = this.response.encodeURL(url);
        }
        return url;
    }
}

