/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.framework.web.mvc.support;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.cfg.CoercionAction;
import com.fasterxml.jackson.databind.cfg.CoercionInputShape;
import com.fasterxml.jackson.databind.type.LogicalType;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.suncode.plugin.framework.Plugin;
import com.suncode.plugin.framework.context.RootContextAware;
import com.suncode.plugin.framework.context.support.RuntimeReferenceFactoryBean;
import com.suncode.plugin.framework.util.SqlDateModule;
import com.suncode.plugin.framework.web.mvc.MvcModuleConfigurer;
import com.suncode.plugin.framework.web.mvc.support.CompositeMvcModuleConfigurer;
import com.suncode.plugin.framework.web.mvc.support.PluginRequestMappingHandlerMapping;
import java.util.List;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistration;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurationSupport;
import org.springframework.web.servlet.i18n.AcceptHeaderLocaleResolver;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public abstract class PluginMvcConfigurationSupport
extends WebMvcConfigurationSupport
implements RootContextAware {
    @Autowired
    private Plugin plugin;
    private ApplicationContext rootContext;
    private CompositeMvcModuleConfigurer configurers = new CompositeMvcModuleConfigurer();

    public Plugin getPlugin() {
        return this.plugin;
    }

    public void setRootContext(ApplicationContext rootContext) {
        this.rootContext = rootContext;
    }

    public ApplicationContext getRootContext() {
        return this.rootContext;
    }

    @Autowired(required=false)
    public void setConfigurers(List<MvcModuleConfigurer> configurers) {
        if (configurers == null || configurers.isEmpty()) {
            return;
        }
        this.configurers.addMvcModuleConfigurers(configurers);
    }

    public CompositeMvcModuleConfigurer getConfigurers() {
        return this.configurers;
    }

    @Bean
    public Object localeResolver() {
        if (this.rootContext.containsBean("localeResolver")) {
            return new RuntimeReferenceFactoryBean("localeResolver", LocaleResolver.class, (BeanFactory)this.rootContext);
        }
        return new AcceptHeaderLocaleResolver();
    }

    public RequestMappingHandlerMapping requestMappingHandlerMapping() {
        PluginRequestMappingHandlerMapping handlerMapping = new PluginRequestMappingHandlerMapping();
        handlerMapping.setOrder(0);
        handlerMapping.setInterceptors(this.getInterceptors());
        handlerMapping.setContentNegotiationManager(this.mvcContentNegotiationManager());
        return handlerMapping;
    }

    protected void addResourceHandlers(ResourceHandlerRegistry registry) {
        String prefix = "/" + this.plugin.getKey() + "/resources/";
        ResourceHandlerRegistration dynamicResources = registry.addResourceHandler(new String[]{prefix + "**"});
        dynamicResources.addResourceLocations(new String[]{"/resources/"});
        dynamicResources.setCachePeriod(Integer.valueOf(1));
        long timestamp = this.plugin.getLastUpdateDate().getTime();
        ResourceHandlerRegistration staticResources = registry.addResourceHandler(new String[]{prefix + timestamp + "/**"});
        staticResources.addResourceLocations(new String[]{"/resources/"});
        staticResources.setCachePeriod(Integer.valueOf(2592000));
    }

    public RequestMappingHandlerAdapter requestMappingHandlerAdapter() {
        RequestMappingHandlerAdapter adapter = super.requestMappingHandlerAdapter();
        adapter.setCacheSeconds(-1);
        MappingJackson2HttpMessageConverter jacksonConverter = adapter.getMessageConverters().stream().filter(converter -> converter instanceof MappingJackson2HttpMessageConverter).map(converter -> (MappingJackson2HttpMessageConverter)converter).findFirst().orElseThrow(() -> new IllegalStateException("Could not find jackson message converter"));
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new SqlDateModule());
        objectMapper.registerModule((Module)new JodaModule());
        objectMapper.coercionConfigFor(LogicalType.POJO).setCoercion(CoercionInputShape.EmptyString, CoercionAction.AsEmpty);
        jacksonConverter.setObjectMapper(objectMapper);
        this.configurers.configureMessageConverters(adapter.getMessageConverters());
        return adapter;
    }
}

