/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.framework.web.mvc.freemarker;

import com.suncode.plugin.framework.Plugin;
import com.suncode.plugin.framework.web.mvc.support.PluginRequestContext;
import com.suncode.plugin.framework.web.support.decorator.ViewDecorator;
import com.suncode.plugin.framework.web.support.decorator.ViewDecoratorResolver;
import freemarker.template.SimpleHash;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.servlet.view.freemarker.FreeMarkerView;

public class DecoratingFreemarkerView
extends FreeMarkerView {
    private static final String VIEW_DECORATOR_ATTR = DecoratingFreemarkerView.class.getName() + ".VIEW_DECORATOR";
    private ViewDecoratorResolver decoratorResolver;
    private Plugin plugin;

    public void setPlugin(Plugin plugin) {
        this.plugin = plugin;
    }

    public void setDecoratorResolver(ViewDecoratorResolver decoratorResolver) {
        this.decoratorResolver = decoratorResolver;
    }

    protected void renderMergedTemplateModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        model.put("pluginContext", (Object)new PluginRequestContext(this.plugin, request, response, this.getServletContext(), model));
        super.renderMergedTemplateModel(model, request, response);
    }

    protected void doRender(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.prepareForDecoration(request, model);
        super.doRender(model, request, response);
    }

    public void prepareForDecoration(HttpServletRequest request, Map<String, Object> model) {
        ViewDecorator decorator;
        if (this.decoratorResolver != null && (decorator = this.decoratorResolver.getDecorator(request)) != null) {
            model.put(VIEW_DECORATOR_ATTR, decorator);
        }
    }

    protected void processTemplate(Template template, SimpleHash model, HttpServletResponse response) throws IOException, TemplateException {
        HttpServletRequest request = (HttpServletRequest)RequestContextHolder.getRequestAttributes().resolveReference("request");
        ViewDecorator decorator = (ViewDecorator)request.getAttribute(VIEW_DECORATOR_ATTR);
        if (decorator != null) {
            this.renderDecoratedTemplate(decorator, template, model, request, response);
        } else {
            super.processTemplate(template, model, response);
        }
    }

    protected void renderDecoratedTemplate(ViewDecorator decorator, Template template, SimpleHash model, HttpServletRequest request, HttpServletResponse response) throws TemplateException, IOException {
        StringWriter writer = new StringWriter();
        template.process((Object)model, (Writer)writer);
        try {
            decorator.decorate(writer.toString(), request, response);
        }
        catch (ServletException e) {
            throw new IOException("Dekoracja widoku nie powiod\u0142a si\u0119", e);
        }
    }
}

