/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.framework.web.mvc;

import com.suncode.plugin.framework.MigratedPlugin;
import com.suncode.plugin.framework.Plugin;
import com.suncode.plugin.framework.web.PluginNotAvailableException;
import com.suncode.plugin.framework.web.PluginWebRequestException;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.util.UrlPathHelper;

public class FrameworkDispatcherServlet
extends HttpServlet {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private UrlPathHelper pathHelper = new UrlPathHelper();
    private final Map<String, DispatcherServlet> pluginServlets = new ConcurrentHashMap<String, DispatcherServlet>();
    private ServletContext servletContext;
    private MessageSourceAccessor messageSource;

    @Autowired
    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    @Autowired
    @Qualifier(value="com.suncode.plugin.framework.MessageSource")
    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = new MessageSourceAccessor(messageSource);
    }

    @PostConstruct
    private void registerServlet() {
        this.logger.info("Rejestracja servletu wtyczek [{}] z mappingiem [{}]", (Object)"pluginMvcServlet", (Object)"/plugin/*");
        ServletRegistration.Dynamic servletRegistration = this.servletContext.addServlet("pluginMvcServlet", (Servlet)this);
        servletRegistration.addMapping(new String[]{"/plugin/*"});
    }

    private void handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String pluginKey = this.getPluginKey(request, response);
        if (MigratedPlugin.contains((String)pluginKey) && MigratedPlugin.DASHBOARDS.pluginKey.equalsIgnoreCase(pluginKey)) {
            response.sendRedirect(request.getContextPath() + "/UserDashboard.do");
            return;
        }
        DispatcherServlet servlet = this.pluginServlets.get(pluginKey);
        if (servlet != null) {
            servlet.service((ServletRequest)request, (ServletResponse)response);
            return;
        }
        response.setStatus(404);
        throw new PluginNotAvailableException(this.messageSource.getMessage("plugin.framework.web.pluginnotavaiable", (Object[])new String[]{pluginKey}));
    }

    private String getPluginKey(HttpServletRequest request, HttpServletResponse response) throws PluginWebRequestException {
        try {
            String path = this.pathHelper.getPathWithinApplication(request).substring("/plugin".length() + 1);
            return path.indexOf(47) > -1 ? path.substring(0, path.indexOf(47)) : path;
        }
        catch (Exception e) {
            response.setStatus(400);
            throw new PluginWebRequestException(this.messageSource.getMessage("plugin.framework.web.invalidpath"), (Throwable)e);
        }
    }

    public void registerPluginDispatcher(Plugin plugin, DispatcherServlet dispatcherServlet) {
        this.pluginServlets.put(plugin.getKey(), dispatcherServlet);
    }

    public void unregisterPluginDispatcher(Plugin plugin) {
        this.pluginServlets.remove(plugin.getKey());
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.handleRequest(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.handleRequest(req, resp);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.handleRequest(req, resp);
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.handleRequest(req, resp);
    }

    protected void doHead(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.handleRequest(req, resp);
    }
}

