/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.framework.web.mvc.support;

import com.suncode.plugin.framework.Plugin;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.servlet.mvc.condition.PatternsRequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class PluginRequestMappingHandlerMapping
extends RequestMappingHandlerMapping {
    @Autowired
    private Plugin plugin;

    protected RequestMappingInfo getMappingForMethod(Method method, Class<?> handlerType) {
        RequestMappingInfo info = super.getMappingForMethod(method, handlerType);
        if (info == null) {
            return null;
        }
        PatternsRequestCondition pluginPatternsCondition = this.processPatternsCondition(info.getPatternsCondition());
        return new RequestMappingInfo(pluginPatternsCondition, info.getMethodsCondition(), info.getParamsCondition(), info.getHeadersCondition(), info.getConsumesCondition(), info.getProducesCondition(), info.getCustomCondition());
    }

    protected PatternsRequestCondition processPatternsCondition(PatternsRequestCondition condition) {
        Assert.notNull((Object)condition, (String)"Patterns condition must not be null");
        String prefix = "/" + this.plugin.getKey();
        Set rawPatterns = condition.getPatterns();
        HashSet<String> patterns = new HashSet<String>();
        for (String pattern : rawPatterns) {
            patterns.add(prefix + pattern);
        }
        return new PatternsRequestCondition(patterns.toArray(new String[patterns.size()]), this.getUrlPathHelper(), this.getPathMatcher(), this.useSuffixPatternMatch(), this.useTrailingSlashMatch(), this.getFileExtensions());
    }
}

