/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.framework.web.mvc.freemarker;

import com.suncode.plugin.framework.web.mvc.freemarker.DecoratingFreemarkerViewResolver;
import com.suncode.plugin.framework.web.mvc.freemarker.FreeMarkerConfigurer;
import com.suncode.plugin.framework.web.mvc.support.PluginMvcConfigurationSupport;
import com.suncode.plugin.framework.web.support.decorator.ViewDecoratorResolver;
import freemarker.cache.TemplateLoader;
import freemarker.ext.jsp.TaglibFactory;
import java.util.Properties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.io.ResourceLoader;
import org.springframework.ui.freemarker.SpringTemplateLoader;

public class FreemarkerMvcConfiguration
extends PluginMvcConfigurationSupport {
    @Bean
    public FreeMarkerConfigurer freemarkerConfigurer() {
        FreeMarkerConfigurer configurer = new FreeMarkerConfigurer();
        Properties settings = new Properties();
        this.configureFreemarker(settings);
        SpringTemplateLoader templateLoader = new SpringTemplateLoader((ResourceLoader)this.getPlugin().getContext(), "/");
        TaglibFactory taglibFactory = (TaglibFactory)this.getRootContext().getBean("com.suncode.plugin.framework.web.TaglibFactory", TaglibFactory.class);
        configurer.setTaglibFactory(taglibFactory);
        configurer.setPreTemplateLoaders(new TemplateLoader[]{templateLoader});
        configurer.setFreemarkerSettings(settings);
        return configurer;
    }

    protected void configureFreemarker(Properties properties) {
        properties.put("localized_lookup", "false");
        properties.put("template_exception_handler", "rethrow");
    }

    @Bean
    public DecoratingFreemarkerViewResolver decoratingFreemarkerViewResolver() {
        DecoratingFreemarkerViewResolver viewResolver = new DecoratingFreemarkerViewResolver();
        viewResolver.setPrefix("/views/");
        viewResolver.setSuffix(".ftl");
        viewResolver.setContentType("text/html;charset=UTF-8");
        if (this.getRootContext().containsBean("decoratorResolver")) {
            viewResolver.setDecoratorResolver((ViewDecoratorResolver)this.getRootContext().getBean("decoratorResolver", ViewDecoratorResolver.class));
        }
        return viewResolver;
    }
}

