/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.framework.web.mvc;

import com.suncode.plugin.framework.PluginContext;
import com.suncode.plugin.framework.PluginsException;
import com.suncode.plugin.framework.context.BeanRegistrationCondition;
import com.suncode.plugin.framework.support.module.ModuleSupport;
import com.suncode.plugin.framework.util.ClassLoaderUtils;
import com.suncode.plugin.framework.web.mvc.FrameworkDispatcherServlet;
import com.suncode.plugin.framework.web.mvc.freemarker.FreemarkerMvcConfiguration;
import com.suncode.plugin.framework.web.mvc.support.DelegatingServletConfig;
import java.lang.reflect.Field;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;
import org.springframework.web.servlet.DispatcherServlet;

public class MvcModule
extends ModuleSupport<Void> {
    private static final Logger logger = LoggerFactory.getLogger(MvcModule.class);
    public static final String MODULE_TYPE = "web-mvc";
    private static final String CONFIGURATION_CLASS_ATTRIBUTE;
    private static final String CONFIGURATION_CLASS_FULL;
    @Autowired
    private FrameworkDispatcherServlet dispatcherServlet;

    protected void initModule() throws PluginsException {
        MvcConfigurationBeanDefinition beanDefinition = new MvcConfigurationBeanDefinition(FreemarkerMvcConfiguration.class);
        this.getPlugin().getContext().registerBeanDefinition(FreemarkerMvcConfiguration.class.getName(), (BeanDefinition)beanDefinition);
        this.getPlugin().getContext().registerConditional("multipartResolver", (BeanDefinition)new RootBeanDefinition(CommonsMultipartResolver.class), BeanRegistrationCondition.beanNotExists((String)"multipartResolver"));
    }

    private DispatcherServlet createDispatcherServlet(WebApplicationContext context) {
        DispatcherServlet servlet = new DispatcherServlet(context);
        servlet.setPublishContext(false);
        servlet.setPublishEvents(false);
        return servlet;
    }

    public void enable() throws PluginsException {
        PluginContext context = this.getPlugin().getContext();
        try {
            DelegatingServletConfig servletConfig = new DelegatingServletConfig(this.getPlugin().getKey(), context.getServletContext());
            DispatcherServlet servlet = this.createDispatcherServlet((WebApplicationContext)context);
            servlet.init((ServletConfig)servletConfig);
            this.dispatcherServlet.registerPluginDispatcher(this.getPlugin(), servlet);
        }
        catch (ServletException e) {
            throw new PluginsException((Throwable)e);
        }
    }

    public void disable() throws PluginsException {
        this.dispatcherServlet.unregisterPluginDispatcher(this.getPlugin());
    }

    static {
        try {
            Class configurationClassUtils = ClassLoaderUtils.loadSystemClass((String)"org.springframework.context.annotation.ConfigurationClassUtils");
            Field attr = ReflectionUtils.findField((Class)configurationClassUtils, (String)"CONFIGURATION_CLASS_ATTRIBUTE", String.class);
            attr.setAccessible(true);
            Field type = ReflectionUtils.findField((Class)configurationClassUtils, (String)"CONFIGURATION_CLASS_FULL", String.class);
            type.setAccessible(true);
            CONFIGURATION_CLASS_ATTRIBUTE = (String)attr.get(null);
            CONFIGURATION_CLASS_FULL = (String)type.get(null);
        }
        catch (Exception e) {
            logger.error("Could not read required fields from internal Spring class.", (Throwable)e);
            throw new RuntimeException("Could not read required fields from internal Spring class.", e);
        }
    }

    static class MvcConfigurationBeanDefinition
    extends RootBeanDefinition {
        public MvcConfigurationBeanDefinition(Class<?> beanClass) {
            super(beanClass);
        }

        public Object getAttribute(String name) {
            if (CONFIGURATION_CLASS_ATTRIBUTE.equals(name)) {
                return CONFIGURATION_CLASS_FULL;
            }
            return super.getAttribute(name);
        }
    }
}

