/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.framework.config;

import com.suncode.plugin.framework.Reference;
import java.beans.ConstructorProperties;
import java.net.URI;
import lombok.NonNull;

public final class URITemplate {
    @NonNull
    private final String template;

    public URI build(Reference pluginRef) {
        return URI.create(this.template.replaceAll("\\{plugin\\.key}", pluginRef.getId()).replaceAll("\\{plugin\\.version}", pluginRef.getVersion().toString()));
    }

    @ConstructorProperties(value={"template"})
    public URITemplate(@NonNull String template) {
        if (template == null) {
            throw new NullPointerException("template is marked non-null but is null");
        }
        this.template = template;
    }

    @NonNull
    public String getTemplate() {
        return this.template;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof URITemplate)) {
            return false;
        }
        URITemplate other = (URITemplate)o;
        String this$template = this.getTemplate();
        String other$template = other.getTemplate();
        return !(this$template == null ? other$template != null : !this$template.equals(other$template));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $template = this.getTemplate();
        result = result * 59 + ($template == null ? 43 : $template.hashCode());
        return result;
    }

    public String toString() {
        return "URITemplate(template=" + this.getTemplate() + ")";
    }
}

