/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.framework.support.module;

import com.suncode.plugin.framework.Plugin;
import com.suncode.plugin.framework.PluginsException;
import com.suncode.plugin.framework.config.ModuleDefinition;
import com.suncode.plugin.framework.support.Condition;
import com.suncode.plugin.framework.support.LocalizedMessage;
import com.suncode.plugin.framework.util.XmlUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.context.MessageSource;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class ModuleHelper {
    public static final String ORDER_ATTR = "order";
    public static final String CLASS_ATTR = "class";
    public static final String LINK_TAG = "link";
    public static final String CONDITION_TAG = "condition";

    public static boolean hasAttribute(String name, ModuleDefinition definition) {
        return definition.getElement().hasAttribute(name);
    }

    public static String getAttribute(String name, ModuleDefinition definition) {
        return ModuleHelper.getAttribute(name, definition, false);
    }

    public static String getAttribute(String name, Element element) {
        return ModuleHelper.getAttribute(name, element, false);
    }

    public static String getAttribute(String name, ModuleDefinition definition, String defaultValue) {
        return ModuleHelper.getAttribute(name, definition.getElement(), defaultValue);
    }

    public static String getAttribute(String name, Element element, String defaultValue) {
        String value = ModuleHelper.getAttribute(name, element, true);
        if (!StringUtils.hasText((String)value)) {
            value = defaultValue;
        }
        return value;
    }

    public static String getAttribute(String name, ModuleDefinition definition, boolean optional) {
        return ModuleHelper.getAttribute(name, definition.getElement(), optional);
    }

    public static String getAttribute(String name, Element element, boolean optional) {
        String value = element.getAttribute(name);
        if (!optional && !StringUtils.hasText((String)value)) {
            throw new IllegalArgumentException("Atrybut [" + name + "] nie ma ustawionej warto\u015bci");
        }
        return value;
    }

    public static int getOrder(ModuleDefinition definition) {
        return ModuleHelper.getOrder(ORDER_ATTR, definition);
    }

    public static int getOrder(String attributeName, ModuleDefinition definition) {
        Assert.hasText((String)attributeName, (String)"Order attribute name must not be empty");
        try {
            String order = ModuleHelper.getAttribute(attributeName, definition, true);
            if (!StringUtils.hasText((String)order)) {
                return Integer.MAX_VALUE;
            }
            return Integer.valueOf(order);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Order attribute is not [ INTEGER ]", e);
        }
    }

    public static LocalizedMessage getLocalizedMessage(String attributeName, Plugin plugin, ModuleDefinition definition) {
        Assert.hasText((String)attributeName, (String)"Attribute name must not be empty");
        String code = ModuleHelper.getAttribute(attributeName, definition);
        return new LocalizedMessage((MessageSource)plugin.getContext(), code, new Object[0]);
    }

    public static List<Condition> getConditions(Plugin plugin, ModuleDefinition definition) throws PluginsException {
        NodeList conditionNodes = definition.getElement().getElementsByTagName(CONDITION_TAG);
        ArrayList<Condition> conditions = new ArrayList<Condition>(conditionNodes.getLength());
        for (int i = 0; i < conditionNodes.getLength(); ++i) {
            Element conditionNode = (Element)conditionNodes.item(i);
            String className = conditionNode.getAttribute(CLASS_ATTR);
            Map<String, String> params = XmlUtils.getParameterMap("param", "name", conditionNode);
            try {
                Class<?> conditionClass = plugin.getClassLoader().loadClass(className);
                Condition condition = (Condition)plugin.getContext().injectDependencies(conditionClass);
                condition.init(params);
                conditions.add(condition);
                continue;
            }
            catch (Exception e) {
                throw new PluginsException(e);
            }
        }
        return conditions;
    }
}

