/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.framework.util;

import java.io.File;
import java.net.MalformedURLException;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.util.Assert;

public abstract class PluginFrameworkUtils {
    public static boolean isPluginFile(File file) {
        Assert.notNull((Object)file, (String)"Plugin file is required");
        Resource descriptor = PluginFrameworkUtils.getDescriptorResource(file);
        return descriptor.exists();
    }

    public static Resource getDescriptorResource(File file) {
        String path = "jar:" + file.toURI() + "!/" + "suncode-plugin.xml";
        try {
            return new UrlResource(path);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

