/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pluginconfigurationmanager.transfer;

import com.suncode.plugin.framework.Plugin;
import com.suncode.plugin.framework.PluginsException;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.content.service.InternalFileContentService;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.domain.PluginConfigurationFile;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.dto.UpdateConfigurationFileDto;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.initconfiguration.InitConfigurationDto;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.initconfiguration.InitConfigurationProvider;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.model.FileType;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.service.PluginConfigurationFileService;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.service.PluginConfigurationService;
import com.suncode.plugin.pluginconfigurationmanager.transfer.ConfigurationFileDto;
import com.suncode.plugin.pluginconfigurationmanager.transfer.ConfigurationPCMRootDto;
import com.suncode.plugin.pluginconfigurationmanager.transfer.ConfigurationPluginDto;
import com.suncode.plugin.pluginconfigurationmanager.transfer.ConfigurationTransferElementType;
import com.suncode.pwfl.configuration.audit.ConfigurationTransferAudit;
import com.suncode.pwfl.configuration.dto.plugins.PluginConfigurationDtoRoot;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ConfigurationImporter {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationImporter.class);
    private final Plugin plugin;
    private final InternalFileContentService contentService;
    private final PluginConfigurationFileService fileService;
    private final PluginConfigurationService pluginConfigurationService;

    public void importConfig(PluginConfigurationDtoRoot configuration, ConfigurationTransferAudit importAudit) throws IOException {
        this.validatePlugin(configuration);
        ConfigurationPCMRootDto config = (ConfigurationPCMRootDto)configuration;
        if (!config.getMetadata().isSelected()) {
            return;
        }
        for (ConfigurationPluginDto configurationPlugin : config.getPluginConfigurationsContainer().getOnlySelectedElements()) {
            this.importConfigurations(configurationPlugin, importAudit);
        }
    }

    private void validatePlugin(PluginConfigurationDtoRoot configuration) {
        if (!StringUtils.equalsIgnoreCase((CharSequence)this.plugin.getKey(), (CharSequence)configuration.getPluginId())) {
            throw new PluginsException("The configuration object is not the " + this.plugin.getName() + " plugin configuration");
        }
    }

    private void importConfigurations(ConfigurationPluginDto configurationPlugin, ConfigurationTransferAudit importAudit) throws IOException {
        for (ConfigurationFileDto configurationFileDto : configurationPlugin.getOnlySelectedElements()) {
            try {
                this.processConfigurationFile(configurationPlugin, configurationFileDto, importAudit);
            }
            catch (IllegalArgumentException e) {
                log.info(e.getMessage());
            }
        }
    }

    private void processConfigurationFile(ConfigurationPluginDto configurationPlugin, ConfigurationFileDto configurationFileDto, ConfigurationTransferAudit importAudit) throws IOException {
        long fileId;
        UpdateConfigurationFileDto newFileDto = new UpdateConfigurationFileDto(configurationFileDto.getReadableFileId(), FileType.valueOf(configurationFileDto.getType()));
        Optional<PluginConfigurationFile> optionalConfigFile = this.fileService.getByReadableFileId(newFileDto.getReadableFileId());
        if (optionalConfigFile.isPresent()) {
            PluginConfigurationFile configFile = optionalConfigFile.get();
            fileId = configFile.getId();
            if (!this.shouldUpdateFile(configurationPlugin, configFile)) {
                return;
            }
        } else {
            fileId = this.fileService.create(configurationPlugin.getId(), newFileDto);
        }
        this.contentService.updateFileContent(fileId, configurationFileDto.getContent());
        importAudit.addElement("PLUGIN CONFIGURATION MANAGER " + ConfigurationTransferElementType.READABLE_FILE_ID.getValue(), newFileDto.getReadableFileId());
    }

    private boolean shouldUpdateFile(ConfigurationPluginDto configurationPlugin, PluginConfigurationFile configFile) throws IOException {
        InitConfigurationProvider initConfigurationProvider = this.pluginConfigurationService.getForPlugin(configurationPlugin.getId()).getInitConfigurationProvider();
        if (initConfigurationProvider == null) {
            return false;
        }
        InputStream defaultConfig = initConfigurationProvider.getInitConfigurations().stream().filter(conf -> conf.getReadableFileId().equals(configFile.getReadableFileId())).findFirst().map(InitConfigurationDto::getStream).orElse(null);
        if (defaultConfig == null) {
            return false;
        }
        try (InputStream inputStream = defaultConfig;){
            String defaultConfigContent = IOUtils.toString((InputStream)defaultConfig, (Charset)StandardCharsets.UTF_8).replaceAll("\\s+", "");
            String configContent = this.contentService.readContent(configFile.getId()).getContent().replaceAll("\\s+", "");
            boolean bl = defaultConfigContent.equals(configContent);
            return bl;
        }
    }

    public ConfigurationImporter(Plugin plugin, InternalFileContentService contentService, PluginConfigurationFileService fileService, PluginConfigurationService pluginConfigurationService) {
        this.plugin = plugin;
        this.contentService = contentService;
        this.fileService = fileService;
        this.pluginConfigurationService = pluginConfigurationService;
    }
}

