/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pluginconfigurationmanager.configuration.definition.module;

import com.suncode.plugin.framework.Plugin;
import com.suncode.plugin.framework.PluginsException;
import com.suncode.plugin.framework.config.ModuleDefinition;
import com.suncode.plugin.framework.support.module.ModuleHelper;
import com.suncode.plugin.framework.support.module.ModuleSupport;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.aftersave.AfterSaveConfigHookProvider;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.beforesave.BeforeSaveConfigModifierProvider;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.graphicschema.ConfigurationFileGraphicSchemaProvider;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.initconfiguration.InitConfigurationDto;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.initconfiguration.InitConfigurationProvider;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.listener.ConfigurationFileChangeListener;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.service.ConfigurationFileService;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.template.ConfigurationFileTemplateProvider;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.model.PluginConfigurationDefinition;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.registry.ConfigurationDefinitionRegistry;
import com.suncode.plugin.pluginconfigurationmanager.configuration.plugin.model.PluginInfo;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

public class PluginConfigurationDefinitionRegisterModule
extends ModuleSupport<Void> {
    private static final Logger log = LoggerFactory.getLogger(PluginConfigurationDefinitionRegisterModule.class);
    private Boolean allowFileManagement;
    private String templateProviderClassName;
    private String changeListenerClassName;
    private String graphicSchemaProviderClassName;
    private String initConfigurationProviderClassName;
    private String beforeSaveConfigModifierProviderClassName;
    private String afterSaveConfigHookProviderClassName;
    @Autowired
    private ConfigurationDefinitionRegistry registry;
    @Autowired
    private ConfigurationFileService configurationFileService;

    protected void initModule() throws PluginsException {
        ModuleDefinition definition = this.getDefinition();
        this.allowFileManagement = Boolean.valueOf(ModuleHelper.getAttribute((String)"allow-file-management", (ModuleDefinition)definition, (String)Boolean.TRUE.toString()));
        this.templateProviderClassName = ModuleHelper.getAttribute((String)"template-provider", (ModuleDefinition)definition, (boolean)true);
        this.changeListenerClassName = ModuleHelper.getAttribute((String)"change-listener", (ModuleDefinition)definition, (boolean)true);
        this.graphicSchemaProviderClassName = ModuleHelper.getAttribute((String)"graphic-schema-provider", (ModuleDefinition)definition, (boolean)true);
        this.initConfigurationProviderClassName = ModuleHelper.getAttribute((String)"init-configuration", (ModuleDefinition)definition, (boolean)true);
        this.beforeSaveConfigModifierProviderClassName = ModuleHelper.getAttribute((String)"before-save-config-modifier", (ModuleDefinition)definition, (boolean)true);
        this.afterSaveConfigHookProviderClassName = ModuleHelper.getAttribute((String)"after-save-config-hook", (ModuleDefinition)definition, (boolean)true);
    }

    public void enable() throws PluginsException {
        Plugin plugin = this.getPlugin();
        PluginInfo pluginInfo = new PluginInfo(plugin.getKey(), plugin.getName());
        ConfigurationFileTemplateProvider templateProvider = this.toClassInstance(ConfigurationFileTemplateProvider.class, this.templateProviderClassName);
        ConfigurationFileChangeListener changeListener = this.toClassInstance(ConfigurationFileChangeListener.class, this.changeListenerClassName);
        ConfigurationFileGraphicSchemaProvider graphicSchemaProvider = this.toClassInstance(ConfigurationFileGraphicSchemaProvider.class, this.graphicSchemaProviderClassName);
        InitConfigurationProvider initConfigurationProvider = this.toClassInstance(InitConfigurationProvider.class, this.initConfigurationProviderClassName);
        BeforeSaveConfigModifierProvider beforeSaveConfigModifierProvider = this.toClassInstance(BeforeSaveConfigModifierProvider.class, this.beforeSaveConfigModifierProviderClassName);
        AfterSaveConfigHookProvider afterSaveConfigHookProvider = this.toClassInstance(AfterSaveConfigHookProvider.class, this.afterSaveConfigHookProviderClassName);
        PluginConfigurationDefinition definition = new PluginConfigurationDefinition(pluginInfo, this.allowFileManagement, templateProvider, changeListener, graphicSchemaProvider, initConfigurationProvider, beforeSaveConfigModifierProvider, afterSaveConfigHookProvider);
        this.registry.register(definition);
        if (initConfigurationProvider != null) {
            this.createInitConfiguration(initConfigurationProvider);
        }
    }

    private void createInitConfiguration(InitConfigurationProvider initConfigurationProvider) {
        List<InitConfigurationDto> initConfigurations = initConfigurationProvider.getInitConfigurations();
        for (InitConfigurationDto initConfiguration : initConfigurations) {
            if (!this.configurationFileService.doesFileExist(this.getPlugin().getKey(), initConfiguration.getReadableFileId())) {
                this.configurationFileService.createFile(this.getPlugin().getKey(), initConfiguration.getReadableFileId(), initConfiguration.getFileType());
                this.configurationFileService.saveFile(this.getPlugin().getKey(), initConfiguration.getReadableFileId(), initConfiguration.getStream());
            } else {
                log.info("Configuration file " + initConfiguration.getReadableFileId() + " for plugin " + this.getPlugin().getKey() + " exists. Loading of init configuration was skipped.");
            }
            try {
                initConfiguration.getStream().close();
            }
            catch (IOException e) {
                throw new PluginsException((Throwable)e);
            }
        }
    }

    private <T> T toClassInstance(Class<T> targetClass, String implClassName) throws PluginsException {
        if (StringUtils.isEmpty((Object)implClassName)) {
            return null;
        }
        try {
            Class<?> clazz = this.getPlugin().getClassLoader().loadClass(implClassName);
            if (!targetClass.isAssignableFrom(clazz)) {
                throw new PluginsException("Class " + implClassName + " must implement " + clazz.getName() + " interface");
            }
            return (T)this.getPlugin().getContext().getAutowireCapableBeanFactory().createBean(clazz);
        }
        catch (ClassNotFoundException ex) {
            throw new PluginsException("Can't load class: " + implClassName, (Throwable)ex);
        }
    }

    public void disable() throws PluginsException {
        this.registry.unregister(this.getPlugin().getKey());
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }
}

