/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.template;

import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.template.ConfigurationFileTemplateProvider;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.template.TemplateResponseDto;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.model.PluginConfigurationDefinition;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.service.PluginConfigurationService;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"configuration"})
public class ConfigurationFileTemplateController {
    @Autowired
    private PluginConfigurationService configurationService;

    @ResponseBody
    @RequestMapping(value={"plugin/{pluginId}/template"})
    public TemplateResponseDto getTemplate(@PathVariable String pluginId) throws IOException {
        PluginConfigurationDefinition definition = this.configurationService.getForPlugin(pluginId);
        ConfigurationFileTemplateProvider templateProvider = definition.getTemplateProvider();
        if (templateProvider != null) {
            try (InputStream stream = templateProvider.readTemplate();){
                String templateContent = IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
                TemplateResponseDto templateResponseDto = new TemplateResponseDto(templateContent);
                return templateResponseDto;
            }
        }
        throw new IllegalArgumentException("Plugin " + pluginId + " does not support file template");
    }
}

