/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.dto;

import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.domain.PluginConfigurationFile;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.model.FileType;

public class ConfigurationFileDto {
    private Long id;
    private String readableFileId;
    private FileType fileType;

    public static ConfigurationFileDto fromDomain(PluginConfigurationFile domain) {
        return ConfigurationFileDto.builder().id(domain.getId()).readableFileId(domain.getReadableFileId()).fileType(domain.getFileType()).build();
    }

    public static ConfigurationFileDtoBuilder builder() {
        return new ConfigurationFileDtoBuilder();
    }

    public Long getId() {
        return this.id;
    }

    public String getReadableFileId() {
        return this.readableFileId;
    }

    public FileType getFileType() {
        return this.fileType;
    }

    public ConfigurationFileDto(Long id, String readableFileId, FileType fileType) {
        this.id = id;
        this.readableFileId = readableFileId;
        this.fileType = fileType;
    }

    public static class ConfigurationFileDtoBuilder {
        private Long id;
        private String readableFileId;
        private FileType fileType;

        ConfigurationFileDtoBuilder() {
        }

        public ConfigurationFileDtoBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public ConfigurationFileDtoBuilder readableFileId(String readableFileId) {
            this.readableFileId = readableFileId;
            return this;
        }

        public ConfigurationFileDtoBuilder fileType(FileType fileType) {
            this.fileType = fileType;
            return this;
        }

        public ConfigurationFileDto build() {
            return new ConfigurationFileDto(this.id, this.readableFileId, this.fileType);
        }

        public String toString() {
            return "ConfigurationFileDto.ConfigurationFileDtoBuilder(id=" + this.id + ", readableFileId=" + this.readableFileId + ", fileType=" + String.valueOf((Object)this.fileType) + ")";
        }
    }
}

