/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.content.validator.impl;

import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.content.validator.ContentValidator;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.content.validator.model.ValidationError;
import com.suncode.pwfl.translation.Translator;
import com.suncode.pwfl.translation.Translators;
import java.io.StringReader;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlValidator
implements ContentValidator {
    private static final Logger log = LoggerFactory.getLogger(XmlValidator.class);

    @Override
    public List<ValidationError> validate(String configurationFileContent) {
        Translator translator = Translators.get((String)"com.suncode.plugin-plugin-configuration-manager");
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.parse(new InputSource(new StringReader(configurationFileContent)));
            return new LinkedList<ValidationError>();
        }
        catch (SAXException ex) {
            return Collections.singletonList(new ValidationError(translator.getMessage("incorrectXmlStructure")));
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            return Collections.singletonList(new ValidationError(ex.getLocalizedMessage(), ex));
        }
    }
}

