/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.content.validator.impl;

import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.content.validator.ContentValidator;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.content.validator.model.ValidationError;
import com.suncode.pwfl.translation.Translator;
import com.suncode.pwfl.translation.Translators;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonValidator
implements ContentValidator {
    private static final Logger log = LoggerFactory.getLogger(JsonValidator.class);

    @Override
    public List<ValidationError> validate(String configurationFileContent) {
        Translator translator = Translators.get((String)"com.suncode.plugin-plugin-configuration-manager");
        try {
            new JSONObject(configurationFileContent);
            return new LinkedList<ValidationError>();
        }
        catch (JSONException ex) {
            try {
                new JSONArray(configurationFileContent);
                return new LinkedList<ValidationError>();
            }
            catch (JSONException ex2) {
                return Collections.singletonList(new ValidationError(translator.getMessage("incorrectJsonStructure")));
            }
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            return Collections.singletonList(new ValidationError(ex.getLocalizedMessage(), ex));
        }
    }
}

