import axios from 'axios';
import { absolutePath } from '../../util/pathUtil';
import { PLUGIN_URL } from '../../webpackConfig/url';

class ConfigurationFileService {
  async getForPlugin(pluginId) {
    let files = (await axios.get(absolutePath(`${PLUGIN_URL}/configuration/file/plugin/${encodeURIComponent(pluginId)}`))).data;
    files.sort((item1, item2) => item1.id - item2.id);
    return files;
  }

  async create(pluginId, newFileDto) {
    await axios.post(absolutePath(`${PLUGIN_URL}/configuration/file/plugin/${encodeURIComponent(pluginId)}`), newFileDto);
  }

  async update(fileId, changeFileDto) {
    await axios.post(absolutePath(`${PLUGIN_URL}/configuration/file/${encodeURIComponent(fileId)}`), changeFileDto);
  }

  async delete(fileId) {
    await axios.delete(absolutePath(`${PLUGIN_URL}/configuration/file/${encodeURIComponent(fileId)}`));
  }
}

export default new ConfigurationFileService();
