import axios from 'axios';
import { absolutePath } from '../../util/pathUtil';
import { PLUGIN_URL } from '../../webpackConfig/url';

class ConfigurationContentService {
  async readContent(fileId) {
    return (await axios.get(absolutePath(`${PLUGIN_URL}/configuration/file/${encodeURIComponent(fileId)}/content`))).data;
  }

  async saveContent(fileId, rawContent) {
    await axios.post(absolutePath(`${PLUGIN_URL}/configuration/file/${encodeURIComponent(fileId)}/content`), {
      content: rawContent,
    });
  }

  async validateContent(fileId, rawContent) {
    try {
      await axios.post(absolutePath(`${PLUGIN_URL}/configuration/file/${encodeURIComponent(fileId)}/content/validate`), {
        content: rawContent,
      });
      return {
        success: true,
        errors: [],
      };
    } catch (error) {
      if (error.response.data != null) {
        return {
          success: false,
          errors: error.response.data,
        };
      } else {
        return {
          success: false,
          errors: [],
        };
      }
    }
  }

  async readTemplate(pluginId) {
    return (await axios.get(absolutePath(`${PLUGIN_URL}/configuration/plugin/${encodeURIComponent(pluginId)}/template`))).data;
  }

  async readGraphicSchema(pluginId, fileName) {
    return (await axios.get(absolutePath(`${PLUGIN_URL}/configuration/plugin/${encodeURIComponent(pluginId)}/${fileName}/graphicSchema`))).data;
  }
}

export default new ConfigurationContentService();
