/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pluginconfigurationmanager.transfer;

import com.suncode.plugin.framework.Plugin;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.content.service.InternalFileContentService;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.domain.PluginConfigurationFile;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.model.PluginConfigurationDefinition;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.service.PluginConfigurationService;
import com.suncode.plugin.pluginconfigurationmanager.configuration.plugin.model.PluginInfo;
import com.suncode.plugin.pluginconfigurationmanager.transfer.ConfigurationFileDto;
import com.suncode.plugin.pluginconfigurationmanager.transfer.ConfigurationPCMRootDto;
import com.suncode.plugin.pluginconfigurationmanager.transfer.ConfigurationPluginDto;
import com.suncode.pwfl.configuration.dto.plugins.PluginConfigurationDtoRoot;
import com.suncode.pwfl.util.Sneaky;
import java.util.LinkedList;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class ConfigurationExporter {
    private final Plugin plugin;
    private final PluginConfigurationService configurationService;
    private final InternalFileContentService contentService;

    public PluginConfigurationDtoRoot exportConfig() {
        List<PluginInfo> pluginInfos = this.configurationService.getConfigurationDefinitions().stream().map(PluginConfigurationDefinition::getPluginInfo).toList();
        LinkedList<ConfigurationPluginDto> configurationPlugins = new LinkedList<ConfigurationPluginDto>();
        for (PluginInfo pluginInfo : pluginInfos) {
            ConfigurationPluginDto configurationPluginDto = new ConfigurationPluginDto(pluginInfo.getId(), pluginInfo.getName());
            List<PluginConfigurationFile> pluginConfigs = this.configurationService.getFilesForPlugin(pluginInfo.getId());
            for (PluginConfigurationFile config : pluginConfigs) {
                ConfigurationFileDto configurationFileDto = new ConfigurationFileDto(config.getReadableFileId(), (String)Sneaky.throwing(() -> this.contentService.readContent(config.getId()).getContent()), config.getFileType());
                configurationPluginDto.addFileConfiguration(configurationFileDto);
            }
            configurationPlugins.add(configurationPluginDto);
        }
        return new ConfigurationPCMRootDto(this.plugin.getKey(), this.plugin.getName(), configurationPlugins);
    }

    public ConfigurationExporter(Plugin plugin, PluginConfigurationService configurationService, InternalFileContentService contentService) {
        this.plugin = plugin;
        this.configurationService = configurationService;
        this.contentService = contentService;
    }
}

