/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pluginconfigurationmanager.configuration.definition.service;

import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.domain.PluginConfigurationFile;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.service.PluginConfigurationFileService;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.model.PluginConfigurationDefinition;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.registry.ConfigurationDefinitionRegistry;
import java.util.List;
import java.util.NoSuchElementException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PluginConfigurationService {
    @Autowired
    private ConfigurationDefinitionRegistry registry;
    @Autowired
    private PluginConfigurationFileService fileService;

    public PluginConfigurationDefinition getForPlugin(String pluginId) {
        return this.getConfigurationDefinitions().stream().filter(item -> item.getPluginInfo().getId().equals(pluginId)).findFirst().orElseThrow(NoSuchElementException::new);
    }

    public List<PluginConfigurationDefinition> getConfigurationDefinitions() {
        return this.registry.getAll();
    }

    public List<PluginConfigurationFile> getFilesForPlugin(String pluginId) {
        return this.fileService.getForPlugin(pluginId);
    }
}

