/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.controller;

import com.google.common.collect.ImmutableMap;
import com.suncode.plugin.pluginconfigurationmanager.authorization.AuthorizationUtil;
import com.suncode.plugin.pluginconfigurationmanager.configuration.audit.AuditParameters;
import com.suncode.plugin.pluginconfigurationmanager.configuration.audit.AuditTypes;
import com.suncode.plugin.pluginconfigurationmanager.configuration.audit.AuditUtil;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.domain.PluginConfigurationFile;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.dto.ConfigurationFileDto;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.dto.UpdateConfigurationFileDto;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.service.ConfigurationFileService;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.service.PluginConfigurationFileService;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.model.PluginConfigurationDefinition;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.service.PluginConfigurationService;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"configuration/file"})
public class ConfigurationFileController {
    @Autowired
    private PluginConfigurationService configurationService;
    @Autowired
    private PluginConfigurationFileService fileService;
    @Autowired
    private ConfigurationFileService configurationFileService;

    @ResponseBody
    @RequestMapping(value={"plugin/{pluginId}"})
    public List<ConfigurationFileDto> getForPlugin(@PathVariable String pluginId) {
        PluginConfigurationDefinition definition = this.configurationService.getForPlugin(pluginId);
        return this.configurationService.getFilesForPlugin(definition.getPluginInfo().getId()).stream().map(ConfigurationFileDto::fromDomain).collect(Collectors.toList());
    }

    @ResponseStatus(value=HttpStatus.OK)
    @RequestMapping(value={"plugin/{pluginId}"}, method={RequestMethod.POST})
    public void create(HttpServletRequest request, @PathVariable String pluginId, @RequestBody UpdateConfigurationFileDto newFileDto) {
        AuthorizationUtil.assertAdministrationRights();
        Date started = new Date();
        this.fileService.create(pluginId, newFileDto);
        this.configurationFileService.addTemplateConfigIfAvailable(pluginId, newFileDto.getReadableFileId());
        AuditUtil.audit(request, AuditTypes.AUDIT_PCM_CONFIG_CREATE, this.buildParams(pluginId, newFileDto), started);
    }

    @ResponseStatus(value=HttpStatus.OK)
    @RequestMapping(value={"{fileId}"}, method={RequestMethod.POST})
    public void update(HttpServletRequest request, @PathVariable Long fileId, @RequestBody UpdateConfigurationFileDto changeFileDto) {
        AuthorizationUtil.assertAdministrationRights();
        Date started = new Date();
        this.fileService.update(fileId, changeFileDto);
        PluginConfigurationFile file = this.fileService.get(fileId);
        HashMap<String, Object> params = new HashMap<String, Object>(this.buildParams(file.getPluginId(), changeFileDto));
        params.put(AuditParameters.AUDIT_PCM_FILE_ID.name(), fileId);
        AuditUtil.audit(request, AuditTypes.AUDIT_PCM_CONFIG_UPDATE, params, started);
    }

    private Map<String, Object> buildParams(String pluginId, UpdateConfigurationFileDto newFileDto) {
        return ImmutableMap.builder().put((Object)AuditParameters.AUDIT_PCM_PLUGIN_ID.name(), (Object)pluginId).put((Object)AuditParameters.AUDIT_PCM_READABLE_FILE_ID.name(), (Object)newFileDto.getReadableFileId()).put((Object)AuditParameters.AUDIT_PCM_FILE_TYPE.name(), (Object)newFileDto.getFileType()).build();
    }

    @ResponseStatus(value=HttpStatus.OK)
    @RequestMapping(value={"{fileId}"}, method={RequestMethod.DELETE})
    public void delete(HttpServletRequest request, @PathVariable Long fileId) {
        AuthorizationUtil.assertAdministrationRights();
        Date started = new Date();
        PluginConfigurationFile file = this.fileService.get(fileId);
        ImmutableMap params = ImmutableMap.of((Object)AuditParameters.AUDIT_PCM_PLUGIN_ID.name(), (Object)file.getPluginId(), (Object)AuditParameters.AUDIT_PCM_FILE_ID.name(), (Object)fileId);
        this.fileService.delete(fileId);
        AuditUtil.audit(request, AuditTypes.AUDIT_PCM_CONFIG_DELETE, (Map<String, Object>)params, started);
    }
}

