/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.content.service;

import com.suncode.plugin.framework.PluginStore;
import com.suncode.plugin.framework.PluginStoreResource;
import com.suncode.plugin.framework.service.Provides;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.beforesave.BeforeSaveConfigModifierProvider;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.content.dto.ContentReadResultDto;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.content.exception.NoSuchConfigurationException;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.content.service.InternalFileContentService;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.content.validator.ContentValidator;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.content.validator.model.ValidationError;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.domain.PluginConfigurationFile;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.dto.UpdateConfigurationFileDto;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.listener.ConfigurationFileChangeListener;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.model.FileType;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.service.ConfigurationFileService;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.service.PluginConfigurationFileService;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.template.ConfigurationFileTemplateProvider;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.model.PluginConfigurationDefinition;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.service.PluginConfigurationService;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Provides(value={ConfigurationFileService.class})
public class FileContentServiceImpl
implements ConfigurationFileService,
InternalFileContentService {
    private static final Logger log = LoggerFactory.getLogger(FileContentServiceImpl.class);
    @Autowired
    private PluginStore pluginStore;
    @Autowired
    private PluginConfigurationFileService fileService;
    @Autowired
    private PluginConfigurationService configurationService;

    @Override
    public InputStream readFile(String pluginId, String readableFileId) {
        PluginConfigurationFile file = this.fileService.getForPlugin(pluginId).stream().filter(item -> item.getReadableFileId().equals(readableFileId)).findFirst().orElseThrow(NoSuchConfigurationException::new);
        ContentReadResultDto contentReadResultDto = this.readContent(file.getId());
        return new ByteArrayInputStream(contentReadResultDto.getContent().getBytes(StandardCharsets.UTF_8));
    }

    @Override
    @Transactional
    public void createFile(String pluginId, String readableFileId, FileType fileType) {
        if (!this.doesFileExist(pluginId, readableFileId)) {
            this.fileService.create(pluginId, new UpdateConfigurationFileDto(readableFileId, fileType));
        }
    }

    @Override
    public boolean doesFileExist(String pluginId, String readableFileId) {
        return this.fileService.getForPlugin(pluginId).stream().anyMatch(item -> item.getReadableFileId().equals(readableFileId));
    }

    @Override
    @Transactional
    public void saveFile(String pluginId, String readableFileId, InputStream stream) {
        String content = IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
        PluginConfigurationFile file = this.fileService.getForPlugin(pluginId).stream().filter(pluginConfigurationFile -> pluginConfigurationFile.getReadableFileId().equals(readableFileId)).findFirst().orElseThrow(NoSuchConfigurationException::new);
        this.updateFileContent(file.getId(), content);
    }

    @Override
    @Transactional
    public void addTemplateConfigIfAvailable(String pluginId, String readableFileId) {
        PluginConfigurationDefinition pluginDefinition = this.configurationService.getForPlugin(pluginId);
        ConfigurationFileTemplateProvider templateProvider = pluginDefinition.getTemplateProvider();
        if (templateProvider == null) {
            return;
        }
        try (InputStream templateConfig2 = templateProvider.readTemplate();){
            if (templateConfig2 == null) {
                return;
            }
            this.saveFile(pluginId, readableFileId, templateConfig2);
        }
        catch (IllegalArgumentException templateConfig2) {
        }
        catch (Exception e) {
            log.warn("Cannot get template configuration for plugin: {}. Error: {}", (Object)pluginId, (Object)e.getMessage());
        }
    }

    @Override
    @Transactional
    public void updateFileContent(Long fileId, String rawFileContent) throws IOException {
        PluginConfigurationFile file = this.fileService.get(fileId);
        PluginConfigurationDefinition definition = this.configurationService.getForPlugin(file.getPluginId());
        List<ValidationError> validationErrors = this.validateContent(fileId, rawFileContent);
        if (!validationErrors.isEmpty()) {
            throw new IllegalArgumentException("File type validation did not pass");
        }
        String filePath = this.resolveRelativePath(file);
        this.backup(file, filePath);
        try (ByteArrayInputStream stream = new ByteArrayInputStream(rawFileContent.getBytes(StandardCharsets.UTF_8));){
            BeforeSaveConfigModifierProvider modifierProvider = definition.getBeforeSaveConfigModifierProvider();
            InputStream modifiedStream = stream;
            if (modifierProvider != null) {
                modifiedStream = modifierProvider.modifyConfig(stream, file.getReadableFileId(), file.getFileType());
            }
            try (ByteArrayInputStream finalStream = modifiedStream;){
                this.pluginStore.store(filePath, (InputStream)finalStream, true);
            }
        }
        ConfigurationFileChangeListener changeListener = definition.getChangeListener();
        if (changeListener != null) {
            changeListener.onFileChange(file.getReadableFileId());
        }
    }

    private void backup(PluginConfigurationFile file, String filePath) throws IOException {
        PluginStoreResource resource = this.pluginStore.read(filePath);
        if (resource != null) {
            try (InputStream stream = resource.getInputStream();){
                String contentToBackup = IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
                try (ByteArrayInputStream contentToBackupStream = new ByteArrayInputStream(contentToBackup.getBytes(StandardCharsets.UTF_8));){
                    String backupFilePath = this.resolveRelativeBackupPath(file, String.valueOf(DateTime.now().getMillis()));
                    this.pluginStore.store(backupFilePath, (InputStream)contentToBackupStream, true);
                }
            }
        }
    }

    @Override
    @Transactional
    public List<ValidationError> validateContent(Long fileId, String content) {
        PluginConfigurationFile file = this.fileService.get(fileId);
        ContentValidator fileTypeValidator = file.getFileType().getValidator();
        if (fileTypeValidator != null) {
            return fileTypeValidator.validate(content);
        }
        return new LinkedList<ValidationError>();
    }

    @Override
    @Transactional
    public ContentReadResultDto readContent(Long fileId) throws IOException {
        PluginConfigurationFile file = this.fileService.get(fileId);
        String filePath = this.resolveRelativePath(file);
        PluginStoreResource resource = this.pluginStore.read(filePath);
        if (resource == null) {
            return new ContentReadResultDto(false, "");
        }
        try (InputStream stream = resource.getInputStream();){
            String content = IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
            ContentReadResultDto contentReadResultDto = new ContentReadResultDto(true, content);
            return contentReadResultDto;
        }
    }

    @Override
    public String[] getAllReadableFilesIds(String pluginId) {
        return (String[])this.fileService.getForPlugin(pluginId).stream().map(item -> item.getReadableFileId()).toArray(String[]::new);
    }

    private String resolveRelativePath(PluginConfigurationFile file) {
        return String.format("configFiles/%s/%s", file.getPluginId().replace(".", "_"), file.getId().toString());
    }

    private String resolveRelativeBackupPath(PluginConfigurationFile file, String fileName) {
        return String.format("configFiles/%s/%s_backup/%s", file.getPluginId().replace(".", "_"), file.getId().toString(), fileName);
    }
}

