/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.content.controller;

import com.google.common.collect.ImmutableMap;
import com.suncode.plugin.pluginconfigurationmanager.authorization.AuthorizationUtil;
import com.suncode.plugin.pluginconfigurationmanager.configuration.audit.AuditParameters;
import com.suncode.plugin.pluginconfigurationmanager.configuration.audit.AuditTypes;
import com.suncode.plugin.pluginconfigurationmanager.configuration.audit.AuditUtil;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.content.dto.ContentDto;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.content.dto.ContentReadResultDto;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.content.service.InternalFileContentService;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.content.validator.model.ValidationError;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.domain.PluginConfigurationFile;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.service.PluginConfigurationFileService;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"configuration/file"})
public class FileContentController {
    @Autowired
    private InternalFileContentService contentService;
    @Autowired
    private PluginConfigurationFileService fileService;

    @ResponseBody
    @RequestMapping(value={"{fileId}/content"})
    public ContentReadResultDto getFileContent(@PathVariable Long fileId) throws IOException {
        return this.contentService.readContent(fileId);
    }

    @ResponseBody
    @RequestMapping(value={"{fileId}/content/validate"}, method={RequestMethod.POST})
    public ResponseEntity<?> validateContent(@PathVariable Long fileId, @RequestBody ContentDto contentDto) {
        List errors = this.contentService.validateContent(fileId, contentDto.getContent()).stream().map(ValidationError::getLocalizedMessage).collect(Collectors.toList());
        if (errors.isEmpty()) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity(errors, (HttpStatusCode)HttpStatus.NOT_ACCEPTABLE);
    }

    @ResponseStatus(value=HttpStatus.OK)
    @RequestMapping(value={"{fileId}/content"}, method={RequestMethod.POST})
    public void updateFileContent(HttpServletRequest request, @PathVariable Long fileId, @RequestBody ContentDto contentDto) throws IOException {
        AuthorizationUtil.assertAdministrationRights();
        Date started = new Date();
        this.contentService.updateFileContent(fileId, contentDto.getContent());
        PluginConfigurationFile file = this.fileService.get(fileId);
        ImmutableMap params = ImmutableMap.of((Object)AuditParameters.AUDIT_PCM_PLUGIN_ID.name(), (Object)file.getPluginId(), (Object)AuditParameters.AUDIT_PCM_READABLE_FILE_ID.name(), (Object)file.getReadableFileId(), (Object)AuditParameters.AUDIT_PCM_FILE_ID.name(), (Object)fileId);
        AuditUtil.audit(request, AuditTypes.AUDIT_PCM_CONFIG_UPDATE_CONTENT, (Map<String, Object>)params, started);
    }
}

