import Vue from 'vue';
import VueI18n from 'vue-i18n';

Vue.use(VueI18n);

export function createI18n() {
  let bundle = PW.I18N.bundle('com.suncode.plugin-plugin-configuration-manager');
  let locale = Suncode.getUserLocale();
  let messages = {
    [locale]: bundle,
  };

  return new VueI18n({
    locale,
    messages,
  });
}

export function translate(key) {
  return PW.I18N.createT('com.suncode.plugin-plugin-configuration-manager')(key);
}
