export function downloadFile(filename, fileContent) {
  let blob = new Blob([fileContent], { type: 'application/octet-stream' });
  if (window.navigator.msSaveOrOpenBlob) {
    window.navigator.msSaveBlob(blob, filename);
  } else {
    let hrefElement = window.document.createElement('a');
    hrefElement.href = window.URL.createObjectURL(blob);
    hrefElement.download = filename;
    document.body.appendChild(hrefElement);
    hrefElement.click();
    document.body.removeChild(hrefElement);
  }
}
